@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkPortMirroringPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property portMirroringId NSX Port Mirroring identifier. Generally the same as the Port Mirroring display name
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetWorkloadNetworkPortMirroringPlainArgs(
    public val portMirroringId: String,
    public val privateCloudName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkPortMirroringPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkPortMirroringPlainArgs = com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkPortMirroringPlainArgs.builder()
        .portMirroringId(portMirroringId.let({ args0 -> args0 }))
        .privateCloudName(privateCloudName.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkloadNetworkPortMirroringPlainArgs].
 */
@PulumiTagMarker
public class GetWorkloadNetworkPortMirroringPlainArgsBuilder internal constructor() {
    private var portMirroringId: String? = null

    private var privateCloudName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value NSX Port Mirroring identifier. Generally the same as the Port Mirroring display name
     */
    @JvmName("gxjcmcworrxyueav")
    public suspend fun portMirroringId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.portMirroringId = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("glwxmhrwtnqalkbt")
    public suspend fun privateCloudName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ekgersdtloylbsyb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWorkloadNetworkPortMirroringPlainArgs =
        GetWorkloadNetworkPortMirroringPlainArgs(
            portMirroringId = portMirroringId ?: throw PulumiNullFieldException("portMirroringId"),
            privateCloudName = privateCloudName ?: throw PulumiNullFieldException("privateCloudName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
