@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkPublicIPPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateCloudName Name of the private cloud
 * @property publicIPId NSX Public IP Block identifier. Generally the same as the Public IP Block's display name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetWorkloadNetworkPublicIPPlainArgs(
    public val privateCloudName: String,
    public val publicIPId: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkPublicIPPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkPublicIPPlainArgs =
        com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkPublicIPPlainArgs.builder()
            .privateCloudName(privateCloudName.let({ args0 -> args0 }))
            .publicIPId(publicIPId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkloadNetworkPublicIPPlainArgs].
 */
@PulumiTagMarker
public class GetWorkloadNetworkPublicIPPlainArgsBuilder internal constructor() {
    private var privateCloudName: String? = null

    private var publicIPId: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the private cloud
     */
    @JvmName("fjdjhgidvoowlotj")
    public suspend fun privateCloudName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateCloudName = mapped
    }

    /**
     * @param value NSX Public IP Block identifier. Generally the same as the Public IP Block's display name
     */
    @JvmName("kkfvnsmiiadvhyne")
    public suspend fun publicIPId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.publicIPId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dytglntegjctwkhj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWorkloadNetworkPublicIPPlainArgs = GetWorkloadNetworkPublicIPPlainArgs(
        privateCloudName = privateCloudName ?: throw PulumiNullFieldException("privateCloudName"),
        publicIPId = publicIPId ?: throw PulumiNullFieldException("publicIPId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
