@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.VmHostPlacementPolicyPropertiesArgs.builder
import com.pulumi.azurenative.avs.kotlin.enums.AffinityStrength
import com.pulumi.azurenative.avs.kotlin.enums.AffinityType
import com.pulumi.azurenative.avs.kotlin.enums.AzureHybridBenefitType
import com.pulumi.azurenative.avs.kotlin.enums.PlacementPolicyState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VM-Host placement policy properties
 * @property affinityStrength vm-host placement policy affinity strength (should/must)
 * @property affinityType placement policy affinity type
 * @property azureHybridBenefitType placement policy azure hybrid benefit opt-in type
 * @property displayName Display name of the placement policy
 * @property hostMembers Host members list
 * @property state Whether the placement policy is enabled or disabled
 * @property type placement policy type
 * Expected value is 'VmHost'.
 * @property vmMembers Virtual machine members list
 */
public data class VmHostPlacementPolicyPropertiesArgs(
    public val affinityStrength: Output<Either<String, AffinityStrength>>? = null,
    public val affinityType: Output<Either<String, AffinityType>>,
    public val azureHybridBenefitType: Output<Either<String, AzureHybridBenefitType>>? = null,
    public val displayName: Output<String>? = null,
    public val hostMembers: Output<List<String>>,
    public val state: Output<Either<String, PlacementPolicyState>>? = null,
    public val type: Output<String>,
    public val vmMembers: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.VmHostPlacementPolicyPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.VmHostPlacementPolicyPropertiesArgs =
        com.pulumi.azurenative.avs.inputs.VmHostPlacementPolicyPropertiesArgs.builder()
            .affinityStrength(
                affinityStrength?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .affinityType(
                affinityType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .azureHybridBenefitType(
                azureHybridBenefitType?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .hostMembers(hostMembers.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .vmMembers(vmMembers.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [VmHostPlacementPolicyPropertiesArgs].
 */
@PulumiTagMarker
public class VmHostPlacementPolicyPropertiesArgsBuilder internal constructor() {
    private var affinityStrength: Output<Either<String, AffinityStrength>>? = null

    private var affinityType: Output<Either<String, AffinityType>>? = null

    private var azureHybridBenefitType: Output<Either<String, AzureHybridBenefitType>>? = null

    private var displayName: Output<String>? = null

    private var hostMembers: Output<List<String>>? = null

    private var state: Output<Either<String, PlacementPolicyState>>? = null

    private var type: Output<String>? = null

    private var vmMembers: Output<List<String>>? = null

    /**
     * @param value vm-host placement policy affinity strength (should/must)
     */
    @JvmName("lqopndqwmoupiudt")
    public suspend fun affinityStrength(`value`: Output<Either<String, AffinityStrength>>) {
        this.affinityStrength = value
    }

    /**
     * @param value placement policy affinity type
     */
    @JvmName("smdpdnweneqcoiln")
    public suspend fun affinityType(`value`: Output<Either<String, AffinityType>>) {
        this.affinityType = value
    }

    /**
     * @param value placement policy azure hybrid benefit opt-in type
     */
    @JvmName("cnempwsnrsraypfm")
    public suspend fun azureHybridBenefitType(`value`: Output<Either<String, AzureHybridBenefitType>>) {
        this.azureHybridBenefitType = value
    }

    /**
     * @param value Display name of the placement policy
     */
    @JvmName("xmmxfdtfphqisejm")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Host members list
     */
    @JvmName("ebhpepvcukwmquyw")
    public suspend fun hostMembers(`value`: Output<List<String>>) {
        this.hostMembers = value
    }

    @JvmName("eyejgdtkuhjptqjl")
    public suspend fun hostMembers(vararg values: Output<String>) {
        this.hostMembers = Output.all(values.asList())
    }

    /**
     * @param values Host members list
     */
    @JvmName("doipcrbgyklbwhjn")
    public suspend fun hostMembers(values: List<Output<String>>) {
        this.hostMembers = Output.all(values)
    }

    /**
     * @param value Whether the placement policy is enabled or disabled
     */
    @JvmName("osiafjsrimwcclrb")
    public suspend fun state(`value`: Output<Either<String, PlacementPolicyState>>) {
        this.state = value
    }

    /**
     * @param value placement policy type
     * Expected value is 'VmHost'.
     */
    @JvmName("idhrlmefdmdrtwgn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Virtual machine members list
     */
    @JvmName("pxjrtmgccttbgnsn")
    public suspend fun vmMembers(`value`: Output<List<String>>) {
        this.vmMembers = value
    }

    @JvmName("kyftroofkwneduns")
    public suspend fun vmMembers(vararg values: Output<String>) {
        this.vmMembers = Output.all(values.asList())
    }

    /**
     * @param values Virtual machine members list
     */
    @JvmName("mvxtxtkphblotbbu")
    public suspend fun vmMembers(values: List<Output<String>>) {
        this.vmMembers = Output.all(values)
    }

    /**
     * @param value vm-host placement policy affinity strength (should/must)
     */
    @JvmName("cjlfbyqtqerxdpcl")
    public suspend fun affinityStrength(`value`: Either<String, AffinityStrength>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.affinityStrength = mapped
    }

    /**
     * @param value vm-host placement policy affinity strength (should/must)
     */
    @JvmName("hfvlxxhbrvyblmhh")
    public fun affinityStrength(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AffinityStrength>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.affinityStrength = mapped
    }

    /**
     * @param value vm-host placement policy affinity strength (should/must)
     */
    @JvmName("heafukfouisetudq")
    public fun affinityStrength(`value`: AffinityStrength) {
        val toBeMapped = Either.ofRight<String, AffinityStrength>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.affinityStrength = mapped
    }

    /**
     * @param value placement policy affinity type
     */
    @JvmName("njjkysafohxwdntl")
    public suspend fun affinityType(`value`: Either<String, AffinityType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.affinityType = mapped
    }

    /**
     * @param value placement policy affinity type
     */
    @JvmName("xnswannwfjvdyjth")
    public fun affinityType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AffinityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.affinityType = mapped
    }

    /**
     * @param value placement policy affinity type
     */
    @JvmName("iipajlnaegjbemci")
    public fun affinityType(`value`: AffinityType) {
        val toBeMapped = Either.ofRight<String, AffinityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.affinityType = mapped
    }

    /**
     * @param value placement policy azure hybrid benefit opt-in type
     */
    @JvmName("mcimbgcnknfjvflk")
    public suspend fun azureHybridBenefitType(`value`: Either<String, AzureHybridBenefitType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureHybridBenefitType = mapped
    }

    /**
     * @param value placement policy azure hybrid benefit opt-in type
     */
    @JvmName("crbrbylklqstpeiw")
    public fun azureHybridBenefitType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureHybridBenefitType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureHybridBenefitType = mapped
    }

    /**
     * @param value placement policy azure hybrid benefit opt-in type
     */
    @JvmName("vsmvdoprosyskkqx")
    public fun azureHybridBenefitType(`value`: AzureHybridBenefitType) {
        val toBeMapped = Either.ofRight<String, AzureHybridBenefitType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureHybridBenefitType = mapped
    }

    /**
     * @param value Display name of the placement policy
     */
    @JvmName("qbuupelvxbubdmhm")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Host members list
     */
    @JvmName("qqigdbhaxaiedrrs")
    public suspend fun hostMembers(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostMembers = mapped
    }

    /**
     * @param values Host members list
     */
    @JvmName("otvcroldyshebykm")
    public suspend fun hostMembers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostMembers = mapped
    }

    /**
     * @param value Whether the placement policy is enabled or disabled
     */
    @JvmName("ybbkjwsbggajtcwu")
    public suspend fun state(`value`: Either<String, PlacementPolicyState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Whether the placement policy is enabled or disabled
     */
    @JvmName("pjxlphbceslbvybk")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PlacementPolicyState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Whether the placement policy is enabled or disabled
     */
    @JvmName("aehttqyxutiiqvwf")
    public fun state(`value`: PlacementPolicyState) {
        val toBeMapped = Either.ofRight<String, PlacementPolicyState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value placement policy type
     * Expected value is 'VmHost'.
     */
    @JvmName("qdjutlqptjgnkope")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Virtual machine members list
     */
    @JvmName("fcbhstctrgdjaaoo")
    public suspend fun vmMembers(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmMembers = mapped
    }

    /**
     * @param values Virtual machine members list
     */
    @JvmName("utucildyevuptxae")
    public suspend fun vmMembers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmMembers = mapped
    }

    internal fun build(): VmHostPlacementPolicyPropertiesArgs = VmHostPlacementPolicyPropertiesArgs(
        affinityStrength = affinityStrength,
        affinityType = affinityType ?: throw PulumiNullFieldException("affinityType"),
        azureHybridBenefitType = azureHybridBenefitType,
        displayName = displayName,
        hostMembers = hostMembers ?: throw PulumiNullFieldException("hostMembers"),
        state = state,
        type = type ?: throw PulumiNullFieldException("type"),
        vmMembers = vmMembers ?: throw PulumiNullFieldException("vmMembers"),
    )
}
