@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.WorkloadNetworkDhcpRelayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * NSX DHCP Relay
 * @property dhcpType Type of DHCP: SERVER or RELAY.
 * Expected value is 'RELAY'.
 * @property displayName Display name of the DHCP entity.
 * @property revision NSX revision number.
 * @property serverAddresses DHCP Relay Addresses. Max 3.
 */
public data class WorkloadNetworkDhcpRelayArgs(
    public val dhcpType: Output<String>,
    public val displayName: Output<String>? = null,
    public val revision: Output<Double>? = null,
    public val serverAddresses: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.WorkloadNetworkDhcpRelayArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.WorkloadNetworkDhcpRelayArgs =
        com.pulumi.azurenative.avs.inputs.WorkloadNetworkDhcpRelayArgs.builder()
            .dhcpType(dhcpType.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .revision(revision?.applyValue({ args0 -> args0 }))
            .serverAddresses(serverAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WorkloadNetworkDhcpRelayArgs].
 */
@PulumiTagMarker
public class WorkloadNetworkDhcpRelayArgsBuilder internal constructor() {
    private var dhcpType: Output<String>? = null

    private var displayName: Output<String>? = null

    private var revision: Output<Double>? = null

    private var serverAddresses: Output<List<String>>? = null

    /**
     * @param value Type of DHCP: SERVER or RELAY.
     * Expected value is 'RELAY'.
     */
    @JvmName("pvsgpmsrsmenqrfl")
    public suspend fun dhcpType(`value`: Output<String>) {
        this.dhcpType = value
    }

    /**
     * @param value Display name of the DHCP entity.
     */
    @JvmName("swlovrabgaqskdqe")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value NSX revision number.
     */
    @JvmName("wrqedvtdmgxkqany")
    public suspend fun revision(`value`: Output<Double>) {
        this.revision = value
    }

    /**
     * @param value DHCP Relay Addresses. Max 3.
     */
    @JvmName("pvwgshdcvklbrqxo")
    public suspend fun serverAddresses(`value`: Output<List<String>>) {
        this.serverAddresses = value
    }

    @JvmName("wwvvtrnynytjlucn")
    public suspend fun serverAddresses(vararg values: Output<String>) {
        this.serverAddresses = Output.all(values.asList())
    }

    /**
     * @param values DHCP Relay Addresses. Max 3.
     */
    @JvmName("gkrjvgiphmmnnbkp")
    public suspend fun serverAddresses(values: List<Output<String>>) {
        this.serverAddresses = Output.all(values)
    }

    /**
     * @param value Type of DHCP: SERVER or RELAY.
     * Expected value is 'RELAY'.
     */
    @JvmName("jubdpfwxssondwkw")
    public suspend fun dhcpType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dhcpType = mapped
    }

    /**
     * @param value Display name of the DHCP entity.
     */
    @JvmName("bglmjxltkarvuwep")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value NSX revision number.
     */
    @JvmName("anvstbibqlyjgwhy")
    public suspend fun revision(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revision = mapped
    }

    /**
     * @param value DHCP Relay Addresses. Max 3.
     */
    @JvmName("kdfghjessshktxwt")
    public suspend fun serverAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverAddresses = mapped
    }

    /**
     * @param values DHCP Relay Addresses. Max 3.
     */
    @JvmName("ltqsrgxuwhilhowh")
    public suspend fun serverAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverAddresses = mapped
    }

    internal fun build(): WorkloadNetworkDhcpRelayArgs = WorkloadNetworkDhcpRelayArgs(
        dhcpType = dhcpType ?: throw PulumiNullFieldException("dhcpType"),
        displayName = displayName,
        revision = revision,
        serverAddresses = serverAddresses,
    )
}
