@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.WorkloadNetworkDhcpServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * NSX DHCP Server
 * @property dhcpType Type of DHCP: SERVER or RELAY.
 * Expected value is 'SERVER'.
 * @property displayName Display name of the DHCP entity.
 * @property leaseTime DHCP Server Lease Time.
 * @property revision NSX revision number.
 * @property serverAddress DHCP Server Address.
 */
public data class WorkloadNetworkDhcpServerArgs(
    public val dhcpType: Output<String>,
    public val displayName: Output<String>? = null,
    public val leaseTime: Output<Double>? = null,
    public val revision: Output<Double>? = null,
    public val serverAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.WorkloadNetworkDhcpServerArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.WorkloadNetworkDhcpServerArgs =
        com.pulumi.azurenative.avs.inputs.WorkloadNetworkDhcpServerArgs.builder()
            .dhcpType(dhcpType.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .leaseTime(leaseTime?.applyValue({ args0 -> args0 }))
            .revision(revision?.applyValue({ args0 -> args0 }))
            .serverAddress(serverAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkloadNetworkDhcpServerArgs].
 */
@PulumiTagMarker
public class WorkloadNetworkDhcpServerArgsBuilder internal constructor() {
    private var dhcpType: Output<String>? = null

    private var displayName: Output<String>? = null

    private var leaseTime: Output<Double>? = null

    private var revision: Output<Double>? = null

    private var serverAddress: Output<String>? = null

    /**
     * @param value Type of DHCP: SERVER or RELAY.
     * Expected value is 'SERVER'.
     */
    @JvmName("xxidtbfqgdtmrumt")
    public suspend fun dhcpType(`value`: Output<String>) {
        this.dhcpType = value
    }

    /**
     * @param value Display name of the DHCP entity.
     */
    @JvmName("ndiorraidluchhso")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value DHCP Server Lease Time.
     */
    @JvmName("vwiyncmaaglgktkx")
    public suspend fun leaseTime(`value`: Output<Double>) {
        this.leaseTime = value
    }

    /**
     * @param value NSX revision number.
     */
    @JvmName("yjcfrmixmxrkqbig")
    public suspend fun revision(`value`: Output<Double>) {
        this.revision = value
    }

    /**
     * @param value DHCP Server Address.
     */
    @JvmName("jddqxonyttyhavyl")
    public suspend fun serverAddress(`value`: Output<String>) {
        this.serverAddress = value
    }

    /**
     * @param value Type of DHCP: SERVER or RELAY.
     * Expected value is 'SERVER'.
     */
    @JvmName("awtbchndrhbmaxax")
    public suspend fun dhcpType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dhcpType = mapped
    }

    /**
     * @param value Display name of the DHCP entity.
     */
    @JvmName("cepsubsnnpoxcppx")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value DHCP Server Lease Time.
     */
    @JvmName("kgqtftnabnonsqyr")
    public suspend fun leaseTime(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.leaseTime = mapped
    }

    /**
     * @param value NSX revision number.
     */
    @JvmName("urgwyguotkdwtcgd")
    public suspend fun revision(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revision = mapped
    }

    /**
     * @param value DHCP Server Address.
     */
    @JvmName("mrrbvmwhsdcvpucr")
    public suspend fun serverAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverAddress = mapped
    }

    internal fun build(): WorkloadNetworkDhcpServerArgs = WorkloadNetworkDhcpServerArgs(
        dhcpType = dhcpType ?: throw PulumiNullFieldException("dhcpType"),
        displayName = displayName,
        leaseTime = leaseTime,
        revision = revision,
        serverAddress = serverAddress,
    )
}
