@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of a Site Recovery Manager (SRM) addon
 * @property addonType The type of private cloud addon
 * Expected value is 'SRM'.
 * @property licenseKey The Site Recovery Manager (SRM) license
 * @property provisioningState The state of the addon provisioning
 */
public data class AddonSrmPropertiesResponse(
    public val addonType: String,
    public val licenseKey: String? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.AddonSrmPropertiesResponse): AddonSrmPropertiesResponse = AddonSrmPropertiesResponse(
            addonType = javaType.addonType(),
            licenseKey = javaType.licenseKey().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
