@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The properties of a vSphere Replication (VR) addon
 * @property addonType The type of private cloud addon
 * Expected value is 'VR'.
 * @property provisioningState The state of the addon provisioning
 * @property vrsCount The vSphere Replication Server (VRS) count
 */
public data class AddonVrPropertiesResponse(
    public val addonType: String,
    public val provisioningState: String,
    public val vrsCount: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.AddonVrPropertiesResponse): AddonVrPropertiesResponse = AddonVrPropertiesResponse(
            addonType = javaType.addonType(),
            provisioningState = javaType.provisioningState(),
            vrsCount = javaType.vrsCount(),
        )
    }
}
