@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An ExpressRoute Circuit
 * @property expressRouteID Identifier of the ExpressRoute Circuit (Microsoft Colo only)
 * @property expressRoutePrivatePeeringID ExpressRoute Circuit private peering identifier
 * @property primarySubnet CIDR of primary subnet
 * @property secondarySubnet CIDR of secondary subnet
 */
public data class CircuitResponse(
    public val expressRouteID: String,
    public val expressRoutePrivatePeeringID: String,
    public val primarySubnet: String,
    public val secondarySubnet: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.CircuitResponse): CircuitResponse = CircuitResponse(
            expressRouteID = javaType.expressRouteID(),
            expressRoutePrivatePeeringID = javaType.expressRoutePrivatePeeringID(),
            primarySubnet = javaType.primarySubnet(),
            secondarySubnet = javaType.secondarySubnet(),
        )
    }
}
