@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Zone and associated hosts info
 * @property hosts List of hosts belonging to the availability zone in a cluster
 * @property zone Availability zone identifier
 */
public data class ClusterZoneResponse(
    public val hosts: List<String>,
    public val zone: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.ClusterZoneResponse): ClusterZoneResponse = ClusterZoneResponse(
            hosts = javaType.hosts().map({ args0 -> args0 }),
            zone = javaType.zone(),
        )
    }
}
