@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Endpoint addresses
 * @property hcxCloudManager Endpoint for the HCX Cloud Manager
 * @property nsxtManager Endpoint for the NSX-T Data Center manager
 * @property vcsa Endpoint for Virtual Center Server Appliance
 */
public data class EndpointsResponse(
    public val hcxCloudManager: String,
    public val nsxtManager: String,
    public val vcsa: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.EndpointsResponse): EndpointsResponse = EndpointsResponse(
            hcxCloudManager = javaType.hcxCloudManager(),
            nsxtManager = javaType.nsxtManager(),
            vcsa = javaType.vcsa(),
        )
    }
}
