@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * An addon resource
 * @property id Resource ID.
 * @property name Resource name.
 * @property properties The properties of an addon resource
 * @property type Resource type.
 */
public data class GetAddonResult(
    public val id: String,
    public val name: String,
    public val properties: Any,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.GetAddonResult): GetAddonResult = GetAddonResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties(),
            type = javaType.type(),
        )
    }
}
