@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ExpressRoute Circuit Authorization
 * @property expressRouteAuthorizationId The ID of the ExpressRoute Circuit Authorization
 * @property expressRouteAuthorizationKey The key of the ExpressRoute Circuit Authorization
 * @property expressRouteId The ID of the ExpressRoute Circuit
 * @property id Resource ID.
 * @property name Resource name.
 * @property provisioningState The state of the  ExpressRoute Circuit Authorization provisioning
 * @property type Resource type.
 */
public data class GetAuthorizationResult(
    public val expressRouteAuthorizationId: String,
    public val expressRouteAuthorizationKey: String,
    public val expressRouteId: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.GetAuthorizationResult): GetAuthorizationResult = GetAuthorizationResult(
            expressRouteAuthorizationId = javaType.expressRouteAuthorizationId(),
            expressRouteAuthorizationKey = javaType.expressRouteAuthorizationKey(),
            expressRouteId = javaType.expressRouteId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
