@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A cluster resource
 * @property clusterId The identity
 * @property clusterSize The cluster size
 * @property hosts The hosts
 * @property id Resource ID.
 * @property name Resource name.
 * @property provisioningState The state of the cluster provisioning
 * @property sku The cluster SKU
 * @property type Resource type.
 */
public data class GetClusterResult(
    public val clusterId: Int,
    public val clusterSize: Int? = null,
    public val hosts: List<String>? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val sku: SkuResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.GetClusterResult): GetClusterResult = GetClusterResult(
            clusterId = javaType.clusterId(),
            clusterSize = javaType.clusterSize().map({ args0 -> args0 }).orElse(null),
            hosts = javaType.hosts().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.avs.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
