@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A global reach connection resource
 * @property addressPrefix The network used for global reach carved out from the original network block provided for the private cloud
 * @property authorizationKey Authorization key from the peer express route used for the global reach connection
 * @property circuitConnectionStatus The connection status of the global reach connection
 * @property expressRouteId The ID of the Private Cloud's ExpressRoute Circuit that is participating in the global reach connection
 * @property id Resource ID.
 * @property name Resource name.
 * @property peerExpressRouteCircuit Identifier of the ExpressRoute Circuit to peer with in the global reach connection
 * @property provisioningState The state of the  ExpressRoute Circuit Authorization provisioning
 * @property type Resource type.
 */
public data class GetGlobalReachConnectionResult(
    public val addressPrefix: String,
    public val authorizationKey: String? = null,
    public val circuitConnectionStatus: String,
    public val expressRouteId: String? = null,
    public val id: String,
    public val name: String,
    public val peerExpressRouteCircuit: String? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.GetGlobalReachConnectionResult): GetGlobalReachConnectionResult = GetGlobalReachConnectionResult(
            addressPrefix = javaType.addressPrefix(),
            authorizationKey = javaType.authorizationKey().map({ args0 -> args0 }).orElse(null),
            circuitConnectionStatus = javaType.circuitConnectionStatus(),
            expressRouteId = javaType.expressRouteId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            peerExpressRouteCircuit = javaType.peerExpressRouteCircuit().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
