@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An HCX Enterprise Site resource
 * @property activationKey The activation key
 * @property id Resource ID.
 * @property name Resource name.
 * @property status The status of the HCX Enterprise Site
 * @property type Resource type.
 */
public data class GetHcxEnterpriseSiteResult(
    public val activationKey: String,
    public val id: String,
    public val name: String,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.GetHcxEnterpriseSiteResult): GetHcxEnterpriseSiteResult = GetHcxEnterpriseSiteResult(
            activationKey = javaType.activationKey(),
            id = javaType.id(),
            name = javaType.name(),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
