@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * A vSphere Distributed Resource Scheduler (DRS) placement policy
 * @property id Resource ID.
 * @property name Resource name.
 * @property properties placement policy properties
 * @property type Resource type.
 */
public data class GetPlacementPolicyResult(
    public val id: String,
    public val name: String,
    public val properties: Either<VmHostPlacementPolicyPropertiesResponse, VmVmPlacementPolicyPropertiesResponse>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.GetPlacementPolicyResult): GetPlacementPolicyResult = GetPlacementPolicyResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.avs.kotlin.outputs.VmHostPlacementPolicyPropertiesResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.avs.kotlin.outputs.VmVmPlacementPolicyPropertiesResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            type = javaType.type(),
        )
    }
}
