@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An instance of a script executed by a user - custom or AVS
 * @property errors Standard error output stream from the powershell execution
 * @property failureReason Error message if the script was able to run, but if the script itself had errors or powershell threw an exception
 * @property finishedAt Time the script execution was finished
 * @property hiddenParameters Parameters that will be hidden/not visible to ARM, such as passwords and credentials
 * @property id Resource ID.
 * @property information Standard information out stream from the powershell execution
 * @property name Resource name.
 * @property namedOutputs User-defined dictionary.
 * @property output Standard output stream from the powershell execution
 * @property parameters Parameters the script will accept
 * @property provisioningState The state of the script execution resource
 * @property retention Time to live for the resource. If not provided, will be available for 60 days
 * @property scriptCmdletId A reference to the script cmdlet resource if user is running a AVS script
 * @property startedAt Time the script execution was started
 * @property submittedAt Time the script execution was submitted
 * @property timeout Time limit for execution
 * @property type Resource type.
 * @property warnings Standard warning out stream from the powershell execution
 */
public data class GetScriptExecutionLogsResult(
    public val errors: List<String>,
    public val failureReason: String? = null,
    public val finishedAt: String,
    public val hiddenParameters: List<Any>? = null,
    public val id: String,
    public val information: List<String>,
    public val name: String,
    public val namedOutputs: Map<String, Any>? = null,
    public val output: List<String>? = null,
    public val parameters: List<Any>? = null,
    public val provisioningState: String,
    public val retention: String? = null,
    public val scriptCmdletId: String? = null,
    public val startedAt: String,
    public val submittedAt: String,
    public val timeout: String,
    public val type: String,
    public val warnings: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.GetScriptExecutionLogsResult): GetScriptExecutionLogsResult = GetScriptExecutionLogsResult(
            errors = javaType.errors().map({ args0 -> args0 }),
            failureReason = javaType.failureReason().map({ args0 -> args0 }).orElse(null),
            finishedAt = javaType.finishedAt(),
            hiddenParameters = javaType.hiddenParameters().map({ args0 -> args0 }),
            id = javaType.id(),
            information = javaType.information().map({ args0 -> args0 }),
            name = javaType.name(),
            namedOutputs = javaType.namedOutputs().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            output = javaType.output().map({ args0 -> args0 }),
            parameters = javaType.parameters().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            retention = javaType.retention().map({ args0 -> args0 }).orElse(null),
            scriptCmdletId = javaType.scriptCmdletId().map({ args0 -> args0 }).orElse(null),
            startedAt = javaType.startedAt(),
            submittedAt = javaType.submittedAt(),
            timeout = javaType.timeout(),
            type = javaType.type(),
            warnings = javaType.warnings().map({ args0 -> args0 }),
        )
    }
}
