@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * NSX DHCP
 * @property id Resource ID.
 * @property name Resource name.
 * @property properties DHCP properties.
 * @property type Resource type.
 */
public data class GetWorkloadNetworkDhcpResult(
    public val id: String,
    public val name: String,
    public val properties: Either<WorkloadNetworkDhcpRelayResponse, WorkloadNetworkDhcpServerResponse>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.GetWorkloadNetworkDhcpResult): GetWorkloadNetworkDhcpResult = GetWorkloadNetworkDhcpResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.avs.kotlin.outputs.WorkloadNetworkDhcpRelayResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.avs.kotlin.outputs.WorkloadNetworkDhcpServerResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            type = javaType.type(),
        )
    }
}
