@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * NSX Public IP Block
 * @property displayName Display name of the Public IP Block.
 * @property id Resource ID.
 * @property name Resource name.
 * @property numberOfPublicIPs Number of Public IPs requested.
 * @property provisioningState The provisioning state
 * @property publicIPBlock CIDR Block of the Public IP Block.
 * @property type Resource type.
 */
public data class GetWorkloadNetworkPublicIPResult(
    public val displayName: String? = null,
    public val id: String,
    public val name: String,
    public val numberOfPublicIPs: Double? = null,
    public val provisioningState: String,
    public val publicIPBlock: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.GetWorkloadNetworkPublicIPResult): GetWorkloadNetworkPublicIPResult = GetWorkloadNetworkPublicIPResult(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            numberOfPublicIPs = javaType.numberOfPublicIPs().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publicIPBlock = javaType.publicIPBlock(),
            type = javaType.type(),
        )
    }
}
