@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * NSX Segment
 * @property connectedGateway Gateway which to connect segment to.
 * @property displayName Display name of the segment.
 * @property id Resource ID.
 * @property name Resource name.
 * @property portVif Port Vif which segment is associated with.
 * @property provisioningState The provisioning state
 * @property revision NSX revision number.
 * @property status Segment status.
 * @property subnet Subnet which to connect segment to.
 * @property type Resource type.
 */
public data class GetWorkloadNetworkSegmentResult(
    public val connectedGateway: String? = null,
    public val displayName: String? = null,
    public val id: String,
    public val name: String,
    public val portVif: List<WorkloadNetworkSegmentPortVifResponse>,
    public val provisioningState: String,
    public val revision: Double? = null,
    public val status: String,
    public val subnet: WorkloadNetworkSegmentSubnetResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.GetWorkloadNetworkSegmentResult): GetWorkloadNetworkSegmentResult = GetWorkloadNetworkSegmentResult(
            connectedGateway = javaType.connectedGateway().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            portVif = javaType.portVif().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.avs.kotlin.outputs.WorkloadNetworkSegmentPortVifResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            revision = javaType.revision().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
            subnet = javaType.subnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.avs.kotlin.outputs.WorkloadNetworkSegmentSubnetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
