@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * NSX VM Group
 * @property displayName Display name of the VM group.
 * @property id Resource ID.
 * @property members Virtual machine members of this group.
 * @property name Resource name.
 * @property provisioningState The provisioning state
 * @property revision NSX revision number.
 * @property status VM Group status.
 * @property type Resource type.
 */
public data class GetWorkloadNetworkVMGroupResult(
    public val displayName: String? = null,
    public val id: String,
    public val members: List<String>? = null,
    public val name: String,
    public val provisioningState: String,
    public val revision: Double? = null,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.GetWorkloadNetworkVMGroupResult): GetWorkloadNetworkVMGroupResult = GetWorkloadNetworkVMGroupResult(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            members = javaType.members().map({ args0 -> args0 }),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            revision = javaType.revision().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
