@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * vCenter Single Sign On Identity Source
 * @property alias The domain's NetBIOS name
 * @property baseGroupDN The base distinguished name for groups
 * @property baseUserDN The base distinguished name for users
 * @property domain The domain's dns name
 * @property name The name of the identity source
 * @property password The password of the Active Directory user with a minimum of read-only access to Base DN for users and groups.
 * @property primaryServer Primary server URL
 * @property secondaryServer Secondary server URL
 * @property ssl Protect LDAP communication using SSL certificate (LDAPS)
 * @property username The ID of an Active Directory user with a minimum of read-only access to Base DN for users and group
 */
public data class IdentitySourceResponse(
    public val alias: String? = null,
    public val baseGroupDN: String? = null,
    public val baseUserDN: String? = null,
    public val domain: String? = null,
    public val name: String? = null,
    public val password: String? = null,
    public val primaryServer: String? = null,
    public val secondaryServer: String? = null,
    public val ssl: String? = null,
    public val username: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.IdentitySourceResponse): IdentitySourceResponse = IdentitySourceResponse(
            alias = javaType.alias().map({ args0 -> args0 }).orElse(null),
            baseGroupDN = javaType.baseGroupDN().map({ args0 -> args0 }).orElse(null),
            baseUserDN = javaType.baseUserDN().map({ args0 -> args0 }).orElse(null),
            domain = javaType.domain().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            primaryServer = javaType.primaryServer().map({ args0 -> args0 }).orElse(null),
            secondaryServer = javaType.secondaryServer().map({ args0 -> args0 }).orElse(null),
            ssl = javaType.ssl().map({ args0 -> args0 }).orElse(null),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
