@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * a powershell credential object
 * @property name The parameter name
 * @property password password for login
 * @property type The type of execution parameter
 * Expected value is 'Credential'.
 * @property username username for login
 */
public data class PSCredentialExecutionParameterResponse(
    public val name: String,
    public val password: String? = null,
    public val type: String,
    public val username: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.PSCredentialExecutionParameterResponse): PSCredentialExecutionParameterResponse = PSCredentialExecutionParameterResponse(
            name = javaType.name(),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
