@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Identity for the virtual machine.
 * @property principalId The principal ID of private cloud identity. This property will only be provided for a system assigned identity.
 * @property tenantId The tenant ID associated with the private cloud. This property will only be provided for a system assigned identity.
 * @property type The type of identity used for the private cloud. The type 'SystemAssigned' refers to an implicitly created identity. The type 'None' will remove any identities from the Private Cloud.
 */
public data class PrivateCloudIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.PrivateCloudIdentityResponse): PrivateCloudIdentityResponse = PrivateCloudIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
