@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * a plain text value execution parameter
 * @property name The parameter name
 * @property secureValue A secure value for the passed parameter, not to be stored in logs
 * @property type The type of execution parameter
 * Expected value is 'SecureValue'.
 */
public data class ScriptSecureStringExecutionParameterResponse(
    public val name: String,
    public val secureValue: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.ScriptSecureStringExecutionParameterResponse): ScriptSecureStringExecutionParameterResponse = ScriptSecureStringExecutionParameterResponse(
            name = javaType.name(),
            secureValue = javaType.secureValue().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
