@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * a plain text value execution parameter
 * @property name The parameter name
 * @property type The type of execution parameter
 * Expected value is 'Value'.
 * @property value The value for the passed parameter
 */
public data class ScriptStringExecutionParameterResponse(
    public val name: String,
    public val type: String,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.ScriptStringExecutionParameterResponse): ScriptStringExecutionParameterResponse = ScriptStringExecutionParameterResponse(
            name = javaType.name(),
            type = javaType.type(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
