@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * VM-Host placement policy properties
 * @property affinityStrength vm-host placement policy affinity strength (should/must)
 * @property affinityType placement policy affinity type
 * @property azureHybridBenefitType placement policy azure hybrid benefit opt-in type
 * @property displayName Display name of the placement policy
 * @property hostMembers Host members list
 * @property provisioningState The provisioning state
 * @property state Whether the placement policy is enabled or disabled
 * @property type placement policy type
 * Expected value is 'VmHost'.
 * @property vmMembers Virtual machine members list
 */
public data class VmHostPlacementPolicyPropertiesResponse(
    public val affinityStrength: String? = null,
    public val affinityType: String,
    public val azureHybridBenefitType: String? = null,
    public val displayName: String? = null,
    public val hostMembers: List<String>,
    public val provisioningState: String,
    public val state: String? = null,
    public val type: String,
    public val vmMembers: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.VmHostPlacementPolicyPropertiesResponse): VmHostPlacementPolicyPropertiesResponse = VmHostPlacementPolicyPropertiesResponse(
            affinityStrength = javaType.affinityStrength().map({ args0 -> args0 }).orElse(null),
            affinityType = javaType.affinityType(),
            azureHybridBenefitType = javaType.azureHybridBenefitType().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            hostMembers = javaType.hostMembers().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            vmMembers = javaType.vmMembers().map({ args0 -> args0 }),
        )
    }
}
