@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * NSX DHCP Server
 * @property dhcpType Type of DHCP: SERVER or RELAY.
 * Expected value is 'SERVER'.
 * @property displayName Display name of the DHCP entity.
 * @property leaseTime DHCP Server Lease Time.
 * @property provisioningState The provisioning state
 * @property revision NSX revision number.
 * @property segments NSX Segments consuming DHCP.
 * @property serverAddress DHCP Server Address.
 */
public data class WorkloadNetworkDhcpServerResponse(
    public val dhcpType: String,
    public val displayName: String? = null,
    public val leaseTime: Double? = null,
    public val provisioningState: String,
    public val revision: Double? = null,
    public val segments: List<String>,
    public val serverAddress: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.WorkloadNetworkDhcpServerResponse): WorkloadNetworkDhcpServerResponse = WorkloadNetworkDhcpServerResponse(
            dhcpType = javaType.dhcpType(),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            leaseTime = javaType.leaseTime().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            revision = javaType.revision().map({ args0 -> args0 }).orElse(null),
            segments = javaType.segments().map({ args0 -> args0 }),
            serverAddress = javaType.serverAddress().map({ args0 -> args0 }).orElse(null),
        )
    }
}
