@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Subnet configuration for segment
 * @property dhcpRanges DHCP Range assigned for subnet.
 * @property gatewayAddress Gateway address.
 */
public data class WorkloadNetworkSegmentSubnetResponse(
    public val dhcpRanges: List<String>? = null,
    public val gatewayAddress: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.WorkloadNetworkSegmentSubnetResponse): WorkloadNetworkSegmentSubnetResponse = WorkloadNetworkSegmentSubnetResponse(
            dhcpRanges = javaType.dhcpRanges().map({ args0 -> args0 }),
            gatewayAddress = javaType.gatewayAddress().map({ args0 -> args0 }).orElse(null),
        )
    }
}
