@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureactivedirectory.kotlin.inputs

import com.pulumi.azurenative.azureactivedirectory.inputs.B2CResourceSKUArgs.builder
import com.pulumi.azurenative.azureactivedirectory.kotlin.enums.B2CResourceSKUName
import com.pulumi.azurenative.azureactivedirectory.kotlin.enums.B2CResourceSKUTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU properties of the Azure AD B2C tenant. Learn more about Azure AD B2C billing at [aka&#46;ms/b2cBilling](https://aka.ms/b2cBilling).
 * @property name The name of the SKU for the tenant.
 * @property tier The tier of the tenant.
 */
public data class B2CResourceSKUArgs(
    public val name: Output<Either<String, B2CResourceSKUName>>? = null,
    public val tier: Output<Either<String, B2CResourceSKUTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azureactivedirectory.inputs.B2CResourceSKUArgs> {
    override fun toJava(): com.pulumi.azurenative.azureactivedirectory.inputs.B2CResourceSKUArgs =
        com.pulumi.azurenative.azureactivedirectory.inputs.B2CResourceSKUArgs.builder()
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [B2CResourceSKUArgs].
 */
@PulumiTagMarker
public class B2CResourceSKUArgsBuilder internal constructor() {
    private var name: Output<Either<String, B2CResourceSKUName>>? = null

    private var tier: Output<Either<String, B2CResourceSKUTier>>? = null

    /**
     * @param value The name of the SKU for the tenant.
     */
    @JvmName("lpymuujrorvqvsrd")
    public suspend fun name(`value`: Output<Either<String, B2CResourceSKUName>>) {
        this.name = value
    }

    /**
     * @param value The tier of the tenant.
     */
    @JvmName("ydatgirreopmvspp")
    public suspend fun tier(`value`: Output<Either<String, B2CResourceSKUTier>>) {
        this.tier = value
    }

    /**
     * @param value The name of the SKU for the tenant.
     */
    @JvmName("kboxmsqdnywptfrs")
    public suspend fun name(`value`: Either<String, B2CResourceSKUName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the SKU for the tenant.
     */
    @JvmName("elwenljflqdjhrwj")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, B2CResourceSKUName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the SKU for the tenant.
     */
    @JvmName("pgyhwfplexbidsuw")
    public fun name(`value`: B2CResourceSKUName) {
        val toBeMapped = Either.ofRight<String, B2CResourceSKUName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The tier of the tenant.
     */
    @JvmName("fcssabfewmvfdswf")
    public suspend fun tier(`value`: Either<String, B2CResourceSKUTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The tier of the tenant.
     */
    @JvmName("jqygsbahiybepiqe")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, B2CResourceSKUTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The tier of the tenant.
     */
    @JvmName("jxfrorwxvmyqxxwq")
    public fun tier(`value`: B2CResourceSKUTier) {
        val toBeMapped = Either.ofRight<String, B2CResourceSKUTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): B2CResourceSKUArgs = B2CResourceSKUArgs(
        name = name,
        tier = tier,
    )
}
