@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureactivedirectory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * SKU properties of the Azure AD B2C tenant. Learn more about Azure AD B2C billing at [aka&#46;ms/b2cBilling](https://aka.ms/b2cBilling).
 * @property name The name of the SKU for the tenant.
 * @property tier The tier of the tenant.
 */
public data class B2CResourceSKUResponse(
    public val name: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azureactivedirectory.outputs.B2CResourceSKUResponse): B2CResourceSKUResponse = B2CResourceSKUResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
