@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureactivedirectory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The billing configuration for the tenant.
 * @property billingType The type of billing. Will be MAU for all new customers. If 'Auths', it can be updated to 'MAU'. Cannot be changed if value is 'MAU'. Learn more about Azure AD B2C billing at [aka&#46;ms/b2cBilling](https://aka.ms/b2cbilling).
 * @property effectiveStartDateUtc The data from which the billing type took effect
 */
public data class B2CTenantResourcePropertiesResponseBillingConfig(
    public val billingType: String? = null,
    public val effectiveStartDateUtc: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azureactivedirectory.outputs.B2CTenantResourcePropertiesResponseBillingConfig): B2CTenantResourcePropertiesResponseBillingConfig =
            B2CTenantResourcePropertiesResponseBillingConfig(
                billingType = javaType.billingType().map({ args0 -> args0 }).orElse(null),
                effectiveStartDateUtc = javaType.effectiveStartDateUtc(),
            )
    }
}
