@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureactivedirectory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * These properties are used to create the Azure AD for customers tenant. These properties are not part of the Azure resource.
 * @property countryCode Country code of Azure tenant (e.g. 'US'). Refer to [https://aka&#46;ms/ciam-data-location](https://aka.ms/ciam-data-location) to see valid country codes and corresponding data residency locations. If you do not see a country code in an valid data residency location, choose one from the list.
 * @property displayName The display name of the Azure AD for customers tenant.
 */
public data class CreateCIAMTenantPropertiesResponse(
    public val countryCode: String,
    public val displayName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azureactivedirectory.outputs.CreateCIAMTenantPropertiesResponse): CreateCIAMTenantPropertiesResponse = CreateCIAMTenantPropertiesResponse(
            countryCode = javaType.countryCode(),
            displayName = javaType.displayName(),
        )
    }
}
