@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureactivedirectory.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property billingConfig The billing configuration for the tenant.
 * @property id An identifier that represents the Azure AD B2C tenant resource.
 * @property location The location in which the resource is hosted and data resides. Can be one of 'United States', 'Europe', 'Asia Pacific', or 'Australia'. Refer to [this documentation](https://aka.ms/B2CDataResidency) for more information.
 * @property name The name of the Azure AD B2C tenant resource.
 * @property sku SKU properties of the Azure AD B2C tenant. Learn more about Azure AD B2C billing at [aka&#46;ms/b2cBilling](https://aka.ms/b2cBilling).
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource Tags
 * @property tenantId An identifier of the Azure AD B2C tenant.
 * @property type The type of the B2C tenant resource.
 */
public data class GetB2CTenantResult(
    public val billingConfig: B2CTenantResourcePropertiesResponseBillingConfig? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val sku: B2CResourceSKUResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val tenantId: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azureactivedirectory.outputs.GetB2CTenantResult): GetB2CTenantResult = GetB2CTenantResult(
            billingConfig = javaType.billingConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.B2CTenantResourcePropertiesResponseBillingConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.B2CResourceSKUResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
