@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.AzurearcdataFunctions.getActiveDirectoryConnectorPlain
import com.pulumi.azurenative.azurearcdata.AzurearcdataFunctions.getDataControllerPlain
import com.pulumi.azurenative.azurearcdata.AzurearcdataFunctions.getFailoverGroupPlain
import com.pulumi.azurenative.azurearcdata.AzurearcdataFunctions.getPostgresInstancePlain
import com.pulumi.azurenative.azurearcdata.AzurearcdataFunctions.getSqlManagedInstancePlain
import com.pulumi.azurenative.azurearcdata.AzurearcdataFunctions.getSqlServerAvailabilityGroupDetailViewPlain
import com.pulumi.azurenative.azurearcdata.AzurearcdataFunctions.getSqlServerAvailabilityGroupPlain
import com.pulumi.azurenative.azurearcdata.AzurearcdataFunctions.getSqlServerDatabasePlain
import com.pulumi.azurenative.azurearcdata.AzurearcdataFunctions.getSqlServerInstancePlain
import com.pulumi.azurenative.azurearcdata.AzurearcdataFunctions.getSqlServerInstanceTelemetryPlain
import com.pulumi.azurenative.azurearcdata.kotlin.enums.AggregationType
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetActiveDirectoryConnectorPlainArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetActiveDirectoryConnectorPlainArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetDataControllerPlainArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetDataControllerPlainArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetFailoverGroupPlainArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetFailoverGroupPlainArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetPostgresInstancePlainArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetPostgresInstancePlainArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetSqlManagedInstancePlainArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetSqlManagedInstancePlainArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetSqlServerAvailabilityGroupDetailViewPlainArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetSqlServerAvailabilityGroupDetailViewPlainArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetSqlServerAvailabilityGroupPlainArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetSqlServerAvailabilityGroupPlainArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetSqlServerDatabasePlainArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetSqlServerDatabasePlainArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetSqlServerInstancePlainArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetSqlServerInstancePlainArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetSqlServerInstanceTelemetryPlainArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetSqlServerInstanceTelemetryPlainArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetActiveDirectoryConnectorResult
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetDataControllerResult
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetFailoverGroupResult
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetPostgresInstanceResult
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetSqlManagedInstanceResult
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetSqlServerAvailabilityGroupDetailViewResult
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetSqlServerAvailabilityGroupResult
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetSqlServerDatabaseResult
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetSqlServerInstanceResult
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetSqlServerInstanceTelemetryResult
import com.pulumi.core.Either
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetActiveDirectoryConnectorResult.Companion.toKotlin as getActiveDirectoryConnectorResultToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetDataControllerResult.Companion.toKotlin as getDataControllerResultToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetFailoverGroupResult.Companion.toKotlin as getFailoverGroupResultToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetPostgresInstanceResult.Companion.toKotlin as getPostgresInstanceResultToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetSqlManagedInstanceResult.Companion.toKotlin as getSqlManagedInstanceResultToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetSqlServerAvailabilityGroupDetailViewResult.Companion.toKotlin as getSqlServerAvailabilityGroupDetailViewResultToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetSqlServerAvailabilityGroupResult.Companion.toKotlin as getSqlServerAvailabilityGroupResultToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetSqlServerDatabaseResult.Companion.toKotlin as getSqlServerDatabaseResultToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetSqlServerInstanceResult.Companion.toKotlin as getSqlServerInstanceResultToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetSqlServerInstanceTelemetryResult.Companion.toKotlin as getSqlServerInstanceTelemetryResultToKotlin

public object AzurearcdataFunctions {
    /**
     * Retrieves an Active Directory connector resource
     * Azure REST API version: 2023-01-15-preview.
     * Other available API versions: 2024-01-01.
     * @param argument null
     * @return Active directory connector resource
     */
    public suspend fun getActiveDirectoryConnector(argument: GetActiveDirectoryConnectorPlainArgs): GetActiveDirectoryConnectorResult =
        getActiveDirectoryConnectorResultToKotlin(getActiveDirectoryConnectorPlain(argument.toJava()).await())

    /**
     * @see [getActiveDirectoryConnector].
     * @param activeDirectoryConnectorName The name of the Active Directory connector instance
     * @param dataControllerName The name of the data controller
     * @param resourceGroupName The name of the Azure resource group
     * @return Active directory connector resource
     */
    public suspend fun getActiveDirectoryConnector(
        activeDirectoryConnectorName: String,
        dataControllerName: String,
        resourceGroupName: String,
    ): GetActiveDirectoryConnectorResult {
        val argument = GetActiveDirectoryConnectorPlainArgs(
            activeDirectoryConnectorName = activeDirectoryConnectorName,
            dataControllerName = dataControllerName,
            resourceGroupName = resourceGroupName,
        )
        return getActiveDirectoryConnectorResultToKotlin(getActiveDirectoryConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getActiveDirectoryConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurearcdata&#46;kotlin&#46;inputs&#46;GetActiveDirectoryConnectorPlainArgs].
     * @return Active directory connector resource
     */
    public suspend fun getActiveDirectoryConnector(argument: suspend GetActiveDirectoryConnectorPlainArgsBuilder.() -> Unit): GetActiveDirectoryConnectorResult {
        val builder = GetActiveDirectoryConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getActiveDirectoryConnectorResultToKotlin(getActiveDirectoryConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves a dataController resource
     * Azure REST API version: 2023-01-15-preview.
     * Other available API versions: 2024-01-01.
     * @param argument null
     * @return Data controller resource
     */
    public suspend fun getDataController(argument: GetDataControllerPlainArgs): GetDataControllerResult =
        getDataControllerResultToKotlin(getDataControllerPlain(argument.toJava()).await())

    /**
     * @see [getDataController].
     * @param dataControllerName The name of the data controller
     * @param resourceGroupName The name of the Azure resource group
     * @return Data controller resource
     */
    public suspend fun getDataController(dataControllerName: String, resourceGroupName: String): GetDataControllerResult {
        val argument = GetDataControllerPlainArgs(
            dataControllerName = dataControllerName,
            resourceGroupName = resourceGroupName,
        )
        return getDataControllerResultToKotlin(getDataControllerPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataController].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurearcdata&#46;kotlin&#46;inputs&#46;GetDataControllerPlainArgs].
     * @return Data controller resource
     */
    public suspend fun getDataController(argument: suspend GetDataControllerPlainArgsBuilder.() -> Unit): GetDataControllerResult {
        val builder = GetDataControllerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataControllerResultToKotlin(getDataControllerPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves a failover group resource
     * Azure REST API version: 2023-01-15-preview.
     * Other available API versions: 2024-01-01.
     * @param argument null
     * @return A failover group resource.
     */
    public suspend fun getFailoverGroup(argument: GetFailoverGroupPlainArgs): GetFailoverGroupResult =
        getFailoverGroupResultToKotlin(getFailoverGroupPlain(argument.toJava()).await())

    /**
     * @see [getFailoverGroup].
     * @param failoverGroupName The name of the Failover Group
     * @param resourceGroupName The name of the Azure resource group
     * @param sqlManagedInstanceName Name of SQL Managed Instance
     * @return A failover group resource.
     */
    public suspend fun getFailoverGroup(
        failoverGroupName: String,
        resourceGroupName: String,
        sqlManagedInstanceName: String,
    ): GetFailoverGroupResult {
        val argument = GetFailoverGroupPlainArgs(
            failoverGroupName = failoverGroupName,
            resourceGroupName = resourceGroupName,
            sqlManagedInstanceName = sqlManagedInstanceName,
        )
        return getFailoverGroupResultToKotlin(getFailoverGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getFailoverGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurearcdata&#46;kotlin&#46;inputs&#46;GetFailoverGroupPlainArgs].
     * @return A failover group resource.
     */
    public suspend fun getFailoverGroup(argument: suspend GetFailoverGroupPlainArgsBuilder.() -> Unit): GetFailoverGroupResult {
        val builder = GetFailoverGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFailoverGroupResultToKotlin(getFailoverGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves a postgres Instance resource
     * Azure REST API version: 2023-01-15-preview.
     * Other available API versions: 2024-01-01.
     * @param argument null
     * @return A Postgres Instance.
     */
    public suspend fun getPostgresInstance(argument: GetPostgresInstancePlainArgs): GetPostgresInstanceResult =
        getPostgresInstanceResultToKotlin(getPostgresInstancePlain(argument.toJava()).await())

    /**
     * @see [getPostgresInstance].
     * @param postgresInstanceName Name of Postgres Instance
     * @param resourceGroupName The name of the Azure resource group
     * @return A Postgres Instance.
     */
    public suspend fun getPostgresInstance(postgresInstanceName: String, resourceGroupName: String): GetPostgresInstanceResult {
        val argument = GetPostgresInstancePlainArgs(
            postgresInstanceName = postgresInstanceName,
            resourceGroupName = resourceGroupName,
        )
        return getPostgresInstanceResultToKotlin(getPostgresInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getPostgresInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurearcdata&#46;kotlin&#46;inputs&#46;GetPostgresInstancePlainArgs].
     * @return A Postgres Instance.
     */
    public suspend fun getPostgresInstance(argument: suspend GetPostgresInstancePlainArgsBuilder.() -> Unit): GetPostgresInstanceResult {
        val builder = GetPostgresInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPostgresInstanceResultToKotlin(getPostgresInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves a SQL Managed Instance resource
     * Azure REST API version: 2023-01-15-preview.
     * Other available API versions: 2024-01-01.
     * @param argument null
     * @return A SqlManagedInstance.
     */
    public suspend fun getSqlManagedInstance(argument: GetSqlManagedInstancePlainArgs): GetSqlManagedInstanceResult =
        getSqlManagedInstanceResultToKotlin(getSqlManagedInstancePlain(argument.toJava()).await())

    /**
     * @see [getSqlManagedInstance].
     * @param resourceGroupName The name of the Azure resource group
     * @param sqlManagedInstanceName Name of SQL Managed Instance
     * @return A SqlManagedInstance.
     */
    public suspend fun getSqlManagedInstance(
        resourceGroupName: String,
        sqlManagedInstanceName: String,
    ): GetSqlManagedInstanceResult {
        val argument = GetSqlManagedInstancePlainArgs(
            resourceGroupName = resourceGroupName,
            sqlManagedInstanceName = sqlManagedInstanceName,
        )
        return getSqlManagedInstanceResultToKotlin(getSqlManagedInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlManagedInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurearcdata&#46;kotlin&#46;inputs&#46;GetSqlManagedInstancePlainArgs].
     * @return A SqlManagedInstance.
     */
    public suspend fun getSqlManagedInstance(argument: suspend GetSqlManagedInstancePlainArgsBuilder.() -> Unit): GetSqlManagedInstanceResult {
        val builder = GetSqlManagedInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlManagedInstanceResultToKotlin(getSqlManagedInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves an Arc Sql Server availability group.
     * Azure REST API version: 2024-01-01.
     * @param argument null
     * @return Arc Sql Server Availability Group
     */
    public suspend fun getSqlServerAvailabilityGroup(argument: GetSqlServerAvailabilityGroupPlainArgs): GetSqlServerAvailabilityGroupResult =
        getSqlServerAvailabilityGroupResultToKotlin(getSqlServerAvailabilityGroupPlain(argument.toJava()).await())

    /**
     * @see [getSqlServerAvailabilityGroup].
     * @param availabilityGroupName Name of SQL Availability Group
     * @param resourceGroupName The name of the Azure resource group
     * @param sqlServerInstanceName Name of SQL Server Instance
     * @return Arc Sql Server Availability Group
     */
    public suspend fun getSqlServerAvailabilityGroup(
        availabilityGroupName: String,
        resourceGroupName: String,
        sqlServerInstanceName: String,
    ): GetSqlServerAvailabilityGroupResult {
        val argument = GetSqlServerAvailabilityGroupPlainArgs(
            availabilityGroupName = availabilityGroupName,
            resourceGroupName = resourceGroupName,
            sqlServerInstanceName = sqlServerInstanceName,
        )
        return getSqlServerAvailabilityGroupResultToKotlin(getSqlServerAvailabilityGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlServerAvailabilityGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurearcdata&#46;kotlin&#46;inputs&#46;GetSqlServerAvailabilityGroupPlainArgs].
     * @return Arc Sql Server Availability Group
     */
    public suspend fun getSqlServerAvailabilityGroup(argument: suspend GetSqlServerAvailabilityGroupPlainArgsBuilder.() -> Unit): GetSqlServerAvailabilityGroupResult {
        val builder = GetSqlServerAvailabilityGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlServerAvailabilityGroupResultToKotlin(getSqlServerAvailabilityGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves detailed properties of the Availability Group.
     * Azure REST API version: 2024-01-01.
     * @param argument null
     * @return Arc Sql Server Availability Group
     */
    public suspend fun getSqlServerAvailabilityGroupDetailView(argument: GetSqlServerAvailabilityGroupDetailViewPlainArgs): GetSqlServerAvailabilityGroupDetailViewResult =
        getSqlServerAvailabilityGroupDetailViewResultToKotlin(getSqlServerAvailabilityGroupDetailViewPlain(argument.toJava()).await())

    /**
     * @see [getSqlServerAvailabilityGroupDetailView].
     * @param availabilityGroupName Name of SQL Availability Group
     * @param resourceGroupName The name of the Azure resource group
     * @param sqlServerInstanceName Name of SQL Server Instance
     * @return Arc Sql Server Availability Group
     */
    public suspend fun getSqlServerAvailabilityGroupDetailView(
        availabilityGroupName: String,
        resourceGroupName: String,
        sqlServerInstanceName: String,
    ): GetSqlServerAvailabilityGroupDetailViewResult {
        val argument = GetSqlServerAvailabilityGroupDetailViewPlainArgs(
            availabilityGroupName = availabilityGroupName,
            resourceGroupName = resourceGroupName,
            sqlServerInstanceName = sqlServerInstanceName,
        )
        return getSqlServerAvailabilityGroupDetailViewResultToKotlin(getSqlServerAvailabilityGroupDetailViewPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlServerAvailabilityGroupDetailView].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurearcdata&#46;kotlin&#46;inputs&#46;GetSqlServerAvailabilityGroupDetailViewPlainArgs].
     * @return Arc Sql Server Availability Group
     */
    public suspend fun getSqlServerAvailabilityGroupDetailView(argument: suspend GetSqlServerAvailabilityGroupDetailViewPlainArgsBuilder.() -> Unit): GetSqlServerAvailabilityGroupDetailViewResult {
        val builder = GetSqlServerAvailabilityGroupDetailViewPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlServerAvailabilityGroupDetailViewResultToKotlin(getSqlServerAvailabilityGroupDetailViewPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves an Arc Sql Server database.
     * Azure REST API version: 2023-01-15-preview.
     * Other available API versions: 2024-01-01.
     * @param argument null
     * @return Arc Sql Server database
     */
    public suspend fun getSqlServerDatabase(argument: GetSqlServerDatabasePlainArgs): GetSqlServerDatabaseResult =
        getSqlServerDatabaseResultToKotlin(getSqlServerDatabasePlain(argument.toJava()).await())

    /**
     * @see [getSqlServerDatabase].
     * @param databaseName Name of the database
     * @param resourceGroupName The name of the Azure resource group
     * @param sqlServerInstanceName Name of SQL Server Instance
     * @return Arc Sql Server database
     */
    public suspend fun getSqlServerDatabase(
        databaseName: String,
        resourceGroupName: String,
        sqlServerInstanceName: String,
    ): GetSqlServerDatabaseResult {
        val argument = GetSqlServerDatabasePlainArgs(
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            sqlServerInstanceName = sqlServerInstanceName,
        )
        return getSqlServerDatabaseResultToKotlin(getSqlServerDatabasePlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlServerDatabase].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurearcdata&#46;kotlin&#46;inputs&#46;GetSqlServerDatabasePlainArgs].
     * @return Arc Sql Server database
     */
    public suspend fun getSqlServerDatabase(argument: suspend GetSqlServerDatabasePlainArgsBuilder.() -> Unit): GetSqlServerDatabaseResult {
        val builder = GetSqlServerDatabasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlServerDatabaseResultToKotlin(getSqlServerDatabasePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves a SQL Server Instance resource
     * Azure REST API version: 2023-01-15-preview.
     * Other available API versions: 2024-01-01.
     * @param argument null
     * @return A SqlServerInstance.
     */
    public suspend fun getSqlServerInstance(argument: GetSqlServerInstancePlainArgs): GetSqlServerInstanceResult =
        getSqlServerInstanceResultToKotlin(getSqlServerInstancePlain(argument.toJava()).await())

    /**
     * @see [getSqlServerInstance].
     * @param resourceGroupName The name of the Azure resource group
     * @param sqlServerInstanceName Name of SQL Server Instance
     * @return A SqlServerInstance.
     */
    public suspend fun getSqlServerInstance(resourceGroupName: String, sqlServerInstanceName: String): GetSqlServerInstanceResult {
        val argument = GetSqlServerInstancePlainArgs(
            resourceGroupName = resourceGroupName,
            sqlServerInstanceName = sqlServerInstanceName,
        )
        return getSqlServerInstanceResultToKotlin(getSqlServerInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlServerInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurearcdata&#46;kotlin&#46;inputs&#46;GetSqlServerInstancePlainArgs].
     * @return A SqlServerInstance.
     */
    public suspend fun getSqlServerInstance(argument: suspend GetSqlServerInstancePlainArgsBuilder.() -> Unit): GetSqlServerInstanceResult {
        val builder = GetSqlServerInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlServerInstanceResultToKotlin(getSqlServerInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves SQL Server instance telemetry
     * Azure REST API version: 2024-01-01.
     * @param argument null
     * @return A section of the telemetry response for the SQL Server instance.
     */
    public suspend fun getSqlServerInstanceTelemetry(argument: GetSqlServerInstanceTelemetryPlainArgs): GetSqlServerInstanceTelemetryResult =
        getSqlServerInstanceTelemetryResultToKotlin(getSqlServerInstanceTelemetryPlain(argument.toJava()).await())

    /**
     * @see [getSqlServerInstanceTelemetry].
     * @param aggregationType The aggregation type to use for the numerical columns in the dataset.
     * @param databaseNames The list of database names to return telemetry for. If not specified, telemetry for all databases will be aggregated and returned.
     * @param datasetName The name of the telemetry dataset to retrieve.
     * @param endTime The end time for the time range to fetch telemetry for. If not specified, the current time is used.
     * @param interval The time granularity to fetch telemetry for. This is an ISO8601 duration. Examples: PT15M, PT1H, P1D
     * @param resourceGroupName The name of the Azure resource group
     * @param sqlServerInstanceName Name of SQL Server Instance
     * @param startTime The start time for the time range to fetch telemetry for. If not specified, the current time minus 1 hour is used.
     * @return A section of the telemetry response for the SQL Server instance.
     */
    public suspend fun getSqlServerInstanceTelemetry(
        aggregationType: Either<String, AggregationType>? = null,
        databaseNames: List<String>? = null,
        datasetName: String,
        endTime: String? = null,
        interval: String? = null,
        resourceGroupName: String,
        sqlServerInstanceName: String,
        startTime: String? = null,
    ): GetSqlServerInstanceTelemetryResult {
        val argument = GetSqlServerInstanceTelemetryPlainArgs(
            aggregationType = aggregationType,
            databaseNames = databaseNames,
            datasetName = datasetName,
            endTime = endTime,
            interval = interval,
            resourceGroupName = resourceGroupName,
            sqlServerInstanceName = sqlServerInstanceName,
            startTime = startTime,
        )
        return getSqlServerInstanceTelemetryResultToKotlin(getSqlServerInstanceTelemetryPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlServerInstanceTelemetry].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurearcdata&#46;kotlin&#46;inputs&#46;GetSqlServerInstanceTelemetryPlainArgs].
     * @return A section of the telemetry response for the SQL Server instance.
     */
    public suspend fun getSqlServerInstanceTelemetry(argument: suspend GetSqlServerInstanceTelemetryPlainArgsBuilder.() -> Unit): GetSqlServerInstanceTelemetryResult {
        val builder = GetSqlServerInstanceTelemetryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlServerInstanceTelemetryResultToKotlin(getSqlServerInstanceTelemetryPlain(builtArgument.toJava()).await())
    }
}
