@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.kotlin.outputs.FailoverGroupPropertiesResponse
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.FailoverGroupPropertiesResponse.Companion.toKotlin as failoverGroupPropertiesResponseToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [FailoverGroup].
 */
@PulumiTagMarker
public class FailoverGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FailoverGroupArgs = FailoverGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FailoverGroupArgsBuilder.() -> Unit) {
        val builder = FailoverGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FailoverGroup {
        val builtJavaResource =
            com.pulumi.azurenative.azurearcdata.FailoverGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FailoverGroup(builtJavaResource)
    }
}

/**
 * A failover group resource.
 * Azure REST API version: 2023-01-15-preview.
 * Other available API versions: 2024-01-01.
 * ## Example Usage
 * ### Create or update a failover group instance.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var failoverGroup = new AzureNative.AzureArcData.FailoverGroup("failoverGroup", new()
 *     {
 *         FailoverGroupName = "testFailoverGroupName",
 *         Properties = new AzureNative.AzureArcData.Inputs.FailoverGroupPropertiesArgs
 *         {
 *             PartnerManagedInstanceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.AzureArcData/sqlManagedInstances/partnerMI",
 *             Spec = new AzureNative.AzureArcData.Inputs.FailoverGroupSpecArgs
 *             {
 *                 PartnerSyncMode = AzureNative.AzureArcData.FailoverGroupPartnerSyncMode.@Async,
 *                 Role = AzureNative.AzureArcData.InstanceFailoverGroupRole.Primary,
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *         SqlManagedInstanceName = "testSqlManagedInstance",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurearcdata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurearcdata.NewFailoverGroup(ctx, "failoverGroup", &azurearcdata.FailoverGroupArgs{
 * 			FailoverGroupName: pulumi.String("testFailoverGroupName"),
 * 			Properties: &azurearcdata.FailoverGroupPropertiesArgs{
 * 				PartnerManagedInstanceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.AzureArcData/sqlManagedInstances/partnerMI"),
 * 				Spec: &azurearcdata.FailoverGroupSpecArgs{
 * 					PartnerSyncMode: pulumi.String(azurearcdata.FailoverGroupPartnerSyncModeAsync),
 * 					Role:            pulumi.String(azurearcdata.InstanceFailoverGroupRolePrimary),
 * 				},
 * 			},
 * 			ResourceGroupName:      pulumi.String("testrg"),
 * 			SqlManagedInstanceName: pulumi.String("testSqlManagedInstance"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurearcdata.FailoverGroup;
 * import com.pulumi.azurenative.azurearcdata.FailoverGroupArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.FailoverGroupPropertiesArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.FailoverGroupSpecArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var failoverGroup = new FailoverGroup("failoverGroup", FailoverGroupArgs.builder()
 *             .failoverGroupName("testFailoverGroupName")
 *             .properties(FailoverGroupPropertiesArgs.builder()
 *                 .partnerManagedInstanceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.AzureArcData/sqlManagedInstances/partnerMI")
 *                 .spec(FailoverGroupSpecArgs.builder()
 *                     .partnerSyncMode("async")
 *                     .role("primary")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("testrg")
 *             .sqlManagedInstanceName("testSqlManagedInstance")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurearcdata:FailoverGroup testFailoverGroupName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/sqlManagedInstances/{sqlManagedInstanceName}/failoverGroups/{failoverGroupName}
 * ```
 */
public class FailoverGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.azurearcdata.FailoverGroup,
) : KotlinCustomResource(javaResource, FailoverGroupMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * null
     */
    public val properties: Output<FailoverGroupPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                failoverGroupPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FailoverGroupMapper : ResourceMapper<FailoverGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurearcdata.FailoverGroup::class == javaResource::class

    override fun map(javaResource: Resource): FailoverGroup = FailoverGroup(
        javaResource as
            com.pulumi.azurenative.azurearcdata.FailoverGroup,
    )
}

/**
 * @see [FailoverGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FailoverGroup].
 */
public suspend fun failoverGroup(
    name: String,
    block: suspend FailoverGroupResourceBuilder.() -> Unit,
): FailoverGroup {
    val builder = FailoverGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FailoverGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun failoverGroup(name: String): FailoverGroup {
    val builder = FailoverGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
