@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.PostgresInstancePropertiesResponse
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.PostgresInstanceSkuResponse
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.PostgresInstancePropertiesResponse.Companion.toKotlin as postgresInstancePropertiesResponseToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.PostgresInstanceSkuResponse.Companion.toKotlin as postgresInstanceSkuResponseToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PostgresInstance].
 */
@PulumiTagMarker
public class PostgresInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PostgresInstanceArgs = PostgresInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PostgresInstanceArgsBuilder.() -> Unit) {
        val builder = PostgresInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PostgresInstance {
        val builtJavaResource =
            com.pulumi.azurenative.azurearcdata.PostgresInstance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PostgresInstance(builtJavaResource)
    }
}

/**
 * A Postgres Instance.
 * Azure REST API version: 2023-01-15-preview. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * Other available API versions: 2024-01-01.
 * ## Example Usage
 * ### Create or update a Postgres Instance.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var postgresInstance = new AzureNative.AzureArcData.PostgresInstance("postgresInstance", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureArcData.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation",
 *             Type = AzureNative.AzureArcData.ExtendedLocationTypes.CustomLocation,
 *         },
 *         Location = "eastus",
 *         PostgresInstanceName = "testpostgresInstance",
 *         Properties = new AzureNative.AzureArcData.Inputs.PostgresInstancePropertiesArgs
 *         {
 *             Admin = "admin",
 *             BasicLoginInformation = new AzureNative.AzureArcData.Inputs.BasicLoginInformationArgs
 *             {
 *                 Password = "********",
 *                 Username = "username",
 *             },
 *             DataControllerId = "dataControllerId",
 *             K8sRaw = new Dictionary<string, object?>
 *             {
 *                 ["apiVersion"] = "apiVersion",
 *                 ["kind"] = "postgresql-12",
 *                 ["metadata"] = new Dictionary<string, object?>
 *                 {
 *                     ["creationTimestamp"] = "2020-08-25T14:55:10Z",
 *                     ["generation"] = 1,
 *                     ["name"] = "pg1",
 *                     ["namespace"] = "test",
 *                     ["resourceVersion"] = "527780",
 *                     ["selfLink"] = "/apis/arcdata.microsoft.com/v1alpha1/namespaces/test/postgresql-12s/pg1",
 *                     ["uid"] = "1111aaaa-ffff-ffff-ffff-99999aaaaaaa",
 *                 },
 *                 ["spec"] = new Dictionary<string, object?>
 *                 {
 *                     ["backups"] = new Dictionary<string, object?>
 *                     {
 *                         ["deltaMinutes"] = 3,
 *                         ["fullMinutes"] = 10,
 *                         ["tiers"] = new[]
 *                         {
 *                             new Dictionary<string, object?>
 *                             {
 *                                 ["retention"] = new Dictionary<string, object?>
 *                                 {
 *                                     ["maximums"] = new[]
 *                                     {
 *                                         "6",
 *                                         "512MB",
 *                                     },
 *                                     ["minimums"] = new[]
 *                                     {
 *                                         "3",
 *                                     },
 *                                 },
 *                                 ["storage"] = new Dictionary<string, object?>
 *                                 {
 *                                     ["volumeSize"] = "1Gi",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     ["engine"] = new Dictionary<string, object?>
 *                     {
 *                         ["extensions"] = new[]
 *                         {
 *                             new Dictionary<string, object?>
 *                             {
 *                                 ["name"] = "citus",
 *                             },
 *                         },
 *                     },
 *                     ["scale"] = new Dictionary<string, object?>
 *                     {
 *                         ["shards"] = 3,
 *                     },
 *                     ["scheduling"] = new Dictionary<string, object?>
 *                     {
 *                         ["default"] = new Dictionary<string, object?>
 *                         {
 *                             ["resources"] = new Dictionary<string, object?>
 *                             {
 *                                 ["requests"] = new Dictionary<string, object?>
 *                                 {
 *                                     ["memory"] = "256Mi",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     ["service"] = new Dictionary<string, object?>
 *                     {
 *                         ["type"] = "NodePort",
 *                     },
 *                     ["storage"] = new Dictionary<string, object?>
 *                     {
 *                         ["data"] = new Dictionary<string, object?>
 *                         {
 *                             ["className"] = "local-storage",
 *                             ["size"] = "5Gi",
 *                         },
 *                         ["logs"] = new Dictionary<string, object?>
 *                         {
 *                             ["className"] = "local-storage",
 *                             ["size"] = "5Gi",
 *                         },
 *                     },
 *                 },
 *                 ["status"] = new Dictionary<string, object?>
 *                 {
 *                     ["externalEndpoint"] = null,
 *                     ["readyPods"] = "4/4",
 *                     ["state"] = "Ready",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *         Sku = new AzureNative.AzureArcData.Inputs.PostgresInstanceSkuArgs
 *         {
 *             Dev = true,
 *             Name = "default",
 *             Tier = AzureNative.AzureArcData.PostgresInstanceSkuTier.Hyperscale,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurearcdata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurearcdata.NewPostgresInstance(ctx, "postgresInstance", &azurearcdata.PostgresInstanceArgs{
 * 			ExtendedLocation: &azurearcdata.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation"),
 * 				Type: pulumi.String(azurearcdata.ExtendedLocationTypesCustomLocation),
 * 			},
 * 			Location:             pulumi.String("eastus"),
 * 			PostgresInstanceName: pulumi.String("testpostgresInstance"),
 * 			Properties: &azurearcdata.PostgresInstancePropertiesArgs{
 * 				Admin: pulumi.String("admin"),
 * 				BasicLoginInformation: &azurearcdata.BasicLoginInformationArgs{
 * 					Password: pulumi.String("********"),
 * 					Username: pulumi.String("username"),
 * 				},
 * 				DataControllerId: pulumi.String("dataControllerId"),
 * 				K8sRaw: pulumi.Any(map[string]interface{}{
 * 					"apiVersion": "apiVersion",
 * 					"kind":       "postgresql-12",
 * 					"metadata": map[string]interface{}{
 * 						"creationTimestamp": "2020-08-25T14:55:10Z",
 * 						"generation":        1,
 * 						"name":              "pg1",
 * 						"namespace":         "test",
 * 						"resourceVersion":   "527780",
 * 						"selfLink":          "/apis/arcdata.microsoft.com/v1alpha1/namespaces/test/postgresql-12s/pg1",
 * 						"uid":               "1111aaaa-ffff-ffff-ffff-99999aaaaaaa",
 * 					},
 * 					"spec": map[string]interface{}{
 * 						"backups": map[string]interface{}{
 * 							"deltaMinutes": 3,
 * 							"fullMinutes":  10,
 * 							"tiers": []map[string]interface{}{
 * 								map[string]interface{}{
 * 									"retention": map[string]interface{}{
 * 										"maximums": []string{
 * 											"6",
 * 											"512MB",
 * 										},
 * 										"minimums": []string{
 * 											"3",
 * 										},
 * 									},
 * 									"storage": map[string]interface{}{
 * 										"volumeSize": "1Gi",
 * 									},
 * 								},
 * 							},
 * 						},
 * 						"engine": map[string]interface{}{
 * 							"extensions": []map[string]interface{}{
 * 								map[string]interface{}{
 * 									"name": "citus",
 * 								},
 * 							},
 * 						},
 * 						"scale": map[string]interface{}{
 * 							"shards": 3,
 * 						},
 * 						"scheduling": map[string]interface{}{
 * 							"default": map[string]interface{}{
 * 								"resources": map[string]interface{}{
 * 									"requests": map[string]interface{}{
 * 										"memory": "256Mi",
 * 									},
 * 								},
 * 							},
 * 						},
 * 						"service": map[string]interface{}{
 * 							"type": "NodePort",
 * 						},
 * 						"storage": map[string]interface{}{
 * 							"data": map[string]interface{}{
 * 								"className": "local-storage",
 * 								"size":      "5Gi",
 * 							},
 * 							"logs": map[string]interface{}{
 * 								"className": "local-storage",
 * 								"size":      "5Gi",
 * 							},
 * 						},
 * 					},
 * 					"status": map[string]interface{}{
 * 						"externalEndpoint": nil,
 * 						"readyPods":        "4/4",
 * 						"state":            "Ready",
 * 					},
 * 				}),
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			Sku: &azurearcdata.PostgresInstanceSkuArgs{
 * 				Dev:  pulumi.Bool(true),
 * 				Name: pulumi.String("default"),
 * 				Tier: azurearcdata.PostgresInstanceSkuTierHyperscale,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurearcdata.PostgresInstance;
 * import com.pulumi.azurenative.azurearcdata.PostgresInstanceArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.PostgresInstancePropertiesArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.BasicLoginInformationArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.PostgresInstanceSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var postgresInstance = new PostgresInstance("postgresInstance", PostgresInstanceArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("eastus")
 *             .postgresInstanceName("testpostgresInstance")
 *             .properties(PostgresInstancePropertiesArgs.builder()
 *                 .admin("admin")
 *                 .basicLoginInformation(BasicLoginInformationArgs.builder()
 *                     .password("********")
 *                     .username("username")
 *                     .build())
 *                 .dataControllerId("dataControllerId")
 *                 .k8sRaw(Map.ofEntries(
 *                     Map.entry("apiVersion", "apiVersion"),
 *                     Map.entry("kind", "postgresql-12"),
 *                     Map.entry("metadata", Map.ofEntries(
 *                         Map.entry("creationTimestamp", "2020-08-25T14:55:10Z"),
 *                         Map.entry("generation", 1),
 *                         Map.entry("name", "pg1"),
 *                         Map.entry("namespace", "test"),
 *                         Map.entry("resourceVersion", "527780"),
 *                         Map.entry("selfLink", "/apis/arcdata.microsoft.com/v1alpha1/namespaces/test/postgresql-12s/pg1"),
 *                         Map.entry("uid", "1111aaaa-ffff-ffff-ffff-99999aaaaaaa")
 *                     )),
 *                     Map.entry("spec", Map.ofEntries(
 *                         Map.entry("backups", Map.ofEntries(
 *                             Map.entry("deltaMinutes", 3),
 *                             Map.entry("fullMinutes", 10),
 *                             Map.entry("tiers", Map.ofEntries(
 *                                 Map.entry("retention", Map.ofEntries(
 *                                     Map.entry("maximums",
 *                                         "6",
 *                                         "512MB"),
 *                                     Map.entry("minimums", "3")
 *                                 )),
 *                                 Map.entry("storage", Map.of("volumeSize", "1Gi"))
 *                             ))
 *                         )),
 *                         Map.entry("engine", Map.of("extensions", Map.of("name", "citus"))),
 *                         Map.entry("scale", Map.of("shards", 3)),
 *                         Map.entry("scheduling", Map.of("default", Map.of("resources", Map.of("requests", Map.of("memory", "256Mi"))))),
 *                         Map.entry("service", Map.of("type", "NodePort")),
 *                         Map.entry("storage", Map.ofEntries(
 *                             Map.entry("data", Map.ofEntries(
 *                                 Map.entry("className", "local-storage"),
 *                                 Map.entry("size", "5Gi")
 *                             )),
 *                             Map.entry("logs", Map.ofEntries(
 *                                 Map.entry("className", "local-storage"),
 *                                 Map.entry("size", "5Gi")
 *                             ))
 *                         ))
 *                     )),
 *                     Map.entry("status", Map.ofEntries(
 *                         Map.entry("externalEndpoint", null),
 *                         Map.entry("readyPods", "4/4"),
 *                         Map.entry("state", "Ready")
 *                     ))
 *                 ))
 *                 .build())
 *             .resourceGroupName("testrg")
 *             .sku(PostgresInstanceSkuArgs.builder()
 *                 .dev(true)
 *                 .name("default")
 *                 .tier("Hyperscale")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurearcdata:PostgresInstance testpostgresInstance /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/postgresInstances/{postgresInstanceName}
 * ```
 */
public class PostgresInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.azurearcdata.PostgresInstance,
) : KotlinCustomResource(javaResource, PostgresInstanceMapper) {
    /**
     * The extendedLocation of the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * null
     */
    public val properties: Output<PostgresInstancePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                postgresInstancePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Resource sku.
     */
    public val sku: Output<PostgresInstanceSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    postgresInstanceSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PostgresInstanceMapper : ResourceMapper<PostgresInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurearcdata.PostgresInstance::class == javaResource::class

    override fun map(javaResource: Resource): PostgresInstance = PostgresInstance(
        javaResource as
            com.pulumi.azurenative.azurearcdata.PostgresInstance,
    )
}

/**
 * @see [PostgresInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PostgresInstance].
 */
public suspend fun postgresInstance(
    name: String,
    block: suspend PostgresInstanceResourceBuilder.() -> Unit,
): PostgresInstance {
    val builder = PostgresInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PostgresInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun postgresInstance(name: String): PostgresInstance {
    val builder = PostgresInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
