@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.PostgresInstanceArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.PostgresInstancePropertiesArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.PostgresInstancePropertiesArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.PostgresInstanceSkuArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.PostgresInstanceSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Postgres Instance.
 * Azure REST API version: 2023-01-15-preview. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * Other available API versions: 2024-01-01.
 * ## Example Usage
 * ### Create or update a Postgres Instance.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var postgresInstance = new AzureNative.AzureArcData.PostgresInstance("postgresInstance", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureArcData.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation",
 *             Type = AzureNative.AzureArcData.ExtendedLocationTypes.CustomLocation,
 *         },
 *         Location = "eastus",
 *         PostgresInstanceName = "testpostgresInstance",
 *         Properties = new AzureNative.AzureArcData.Inputs.PostgresInstancePropertiesArgs
 *         {
 *             Admin = "admin",
 *             BasicLoginInformation = new AzureNative.AzureArcData.Inputs.BasicLoginInformationArgs
 *             {
 *                 Password = "********",
 *                 Username = "username",
 *             },
 *             DataControllerId = "dataControllerId",
 *             K8sRaw = new Dictionary<string, object?>
 *             {
 *                 ["apiVersion"] = "apiVersion",
 *                 ["kind"] = "postgresql-12",
 *                 ["metadata"] = new Dictionary<string, object?>
 *                 {
 *                     ["creationTimestamp"] = "2020-08-25T14:55:10Z",
 *                     ["generation"] = 1,
 *                     ["name"] = "pg1",
 *                     ["namespace"] = "test",
 *                     ["resourceVersion"] = "527780",
 *                     ["selfLink"] = "/apis/arcdata.microsoft.com/v1alpha1/namespaces/test/postgresql-12s/pg1",
 *                     ["uid"] = "1111aaaa-ffff-ffff-ffff-99999aaaaaaa",
 *                 },
 *                 ["spec"] = new Dictionary<string, object?>
 *                 {
 *                     ["backups"] = new Dictionary<string, object?>
 *                     {
 *                         ["deltaMinutes"] = 3,
 *                         ["fullMinutes"] = 10,
 *                         ["tiers"] = new[]
 *                         {
 *                             new Dictionary<string, object?>
 *                             {
 *                                 ["retention"] = new Dictionary<string, object?>
 *                                 {
 *                                     ["maximums"] = new[]
 *                                     {
 *                                         "6",
 *                                         "512MB",
 *                                     },
 *                                     ["minimums"] = new[]
 *                                     {
 *                                         "3",
 *                                     },
 *                                 },
 *                                 ["storage"] = new Dictionary<string, object?>
 *                                 {
 *                                     ["volumeSize"] = "1Gi",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     ["engine"] = new Dictionary<string, object?>
 *                     {
 *                         ["extensions"] = new[]
 *                         {
 *                             new Dictionary<string, object?>
 *                             {
 *                                 ["name"] = "citus",
 *                             },
 *                         },
 *                     },
 *                     ["scale"] = new Dictionary<string, object?>
 *                     {
 *                         ["shards"] = 3,
 *                     },
 *                     ["scheduling"] = new Dictionary<string, object?>
 *                     {
 *                         ["default"] = new Dictionary<string, object?>
 *                         {
 *                             ["resources"] = new Dictionary<string, object?>
 *                             {
 *                                 ["requests"] = new Dictionary<string, object?>
 *                                 {
 *                                     ["memory"] = "256Mi",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     ["service"] = new Dictionary<string, object?>
 *                     {
 *                         ["type"] = "NodePort",
 *                     },
 *                     ["storage"] = new Dictionary<string, object?>
 *                     {
 *                         ["data"] = new Dictionary<string, object?>
 *                         {
 *                             ["className"] = "local-storage",
 *                             ["size"] = "5Gi",
 *                         },
 *                         ["logs"] = new Dictionary<string, object?>
 *                         {
 *                             ["className"] = "local-storage",
 *                             ["size"] = "5Gi",
 *                         },
 *                     },
 *                 },
 *                 ["status"] = new Dictionary<string, object?>
 *                 {
 *                     ["externalEndpoint"] = null,
 *                     ["readyPods"] = "4/4",
 *                     ["state"] = "Ready",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *         Sku = new AzureNative.AzureArcData.Inputs.PostgresInstanceSkuArgs
 *         {
 *             Dev = true,
 *             Name = "default",
 *             Tier = AzureNative.AzureArcData.PostgresInstanceSkuTier.Hyperscale,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurearcdata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurearcdata.NewPostgresInstance(ctx, "postgresInstance", &azurearcdata.PostgresInstanceArgs{
 * 			ExtendedLocation: &azurearcdata.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation"),
 * 				Type: pulumi.String(azurearcdata.ExtendedLocationTypesCustomLocation),
 * 			},
 * 			Location:             pulumi.String("eastus"),
 * 			PostgresInstanceName: pulumi.String("testpostgresInstance"),
 * 			Properties: &azurearcdata.PostgresInstancePropertiesArgs{
 * 				Admin: pulumi.String("admin"),
 * 				BasicLoginInformation: &azurearcdata.BasicLoginInformationArgs{
 * 					Password: pulumi.String("********"),
 * 					Username: pulumi.String("username"),
 * 				},
 * 				DataControllerId: pulumi.String("dataControllerId"),
 * 				K8sRaw: pulumi.Any(map[string]interface{}{
 * 					"apiVersion": "apiVersion",
 * 					"kind":       "postgresql-12",
 * 					"metadata": map[string]interface{}{
 * 						"creationTimestamp": "2020-08-25T14:55:10Z",
 * 						"generation":        1,
 * 						"name":              "pg1",
 * 						"namespace":         "test",
 * 						"resourceVersion":   "527780",
 * 						"selfLink":          "/apis/arcdata.microsoft.com/v1alpha1/namespaces/test/postgresql-12s/pg1",
 * 						"uid":               "1111aaaa-ffff-ffff-ffff-99999aaaaaaa",
 * 					},
 * 					"spec": map[string]interface{}{
 * 						"backups": map[string]interface{}{
 * 							"deltaMinutes": 3,
 * 							"fullMinutes":  10,
 * 							"tiers": []map[string]interface{}{
 * 								map[string]interface{}{
 * 									"retention": map[string]interface{}{
 * 										"maximums": []string{
 * 											"6",
 * 											"512MB",
 * 										},
 * 										"minimums": []string{
 * 											"3",
 * 										},
 * 									},
 * 									"storage": map[string]interface{}{
 * 										"volumeSize": "1Gi",
 * 									},
 * 								},
 * 							},
 * 						},
 * 						"engine": map[string]interface{}{
 * 							"extensions": []map[string]interface{}{
 * 								map[string]interface{}{
 * 									"name": "citus",
 * 								},
 * 							},
 * 						},
 * 						"scale": map[string]interface{}{
 * 							"shards": 3,
 * 						},
 * 						"scheduling": map[string]interface{}{
 * 							"default": map[string]interface{}{
 * 								"resources": map[string]interface{}{
 * 									"requests": map[string]interface{}{
 * 										"memory": "256Mi",
 * 									},
 * 								},
 * 							},
 * 						},
 * 						"service": map[string]interface{}{
 * 							"type": "NodePort",
 * 						},
 * 						"storage": map[string]interface{}{
 * 							"data": map[string]interface{}{
 * 								"className": "local-storage",
 * 								"size":      "5Gi",
 * 							},
 * 							"logs": map[string]interface{}{
 * 								"className": "local-storage",
 * 								"size":      "5Gi",
 * 							},
 * 						},
 * 					},
 * 					"status": map[string]interface{}{
 * 						"externalEndpoint": nil,
 * 						"readyPods":        "4/4",
 * 						"state":            "Ready",
 * 					},
 * 				}),
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			Sku: &azurearcdata.PostgresInstanceSkuArgs{
 * 				Dev:  pulumi.Bool(true),
 * 				Name: pulumi.String("default"),
 * 				Tier: azurearcdata.PostgresInstanceSkuTierHyperscale,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurearcdata.PostgresInstance;
 * import com.pulumi.azurenative.azurearcdata.PostgresInstanceArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.PostgresInstancePropertiesArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.BasicLoginInformationArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.PostgresInstanceSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var postgresInstance = new PostgresInstance("postgresInstance", PostgresInstanceArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("eastus")
 *             .postgresInstanceName("testpostgresInstance")
 *             .properties(PostgresInstancePropertiesArgs.builder()
 *                 .admin("admin")
 *                 .basicLoginInformation(BasicLoginInformationArgs.builder()
 *                     .password("********")
 *                     .username("username")
 *                     .build())
 *                 .dataControllerId("dataControllerId")
 *                 .k8sRaw(Map.ofEntries(
 *                     Map.entry("apiVersion", "apiVersion"),
 *                     Map.entry("kind", "postgresql-12"),
 *                     Map.entry("metadata", Map.ofEntries(
 *                         Map.entry("creationTimestamp", "2020-08-25T14:55:10Z"),
 *                         Map.entry("generation", 1),
 *                         Map.entry("name", "pg1"),
 *                         Map.entry("namespace", "test"),
 *                         Map.entry("resourceVersion", "527780"),
 *                         Map.entry("selfLink", "/apis/arcdata.microsoft.com/v1alpha1/namespaces/test/postgresql-12s/pg1"),
 *                         Map.entry("uid", "1111aaaa-ffff-ffff-ffff-99999aaaaaaa")
 *                     )),
 *                     Map.entry("spec", Map.ofEntries(
 *                         Map.entry("backups", Map.ofEntries(
 *                             Map.entry("deltaMinutes", 3),
 *                             Map.entry("fullMinutes", 10),
 *                             Map.entry("tiers", Map.ofEntries(
 *                                 Map.entry("retention", Map.ofEntries(
 *                                     Map.entry("maximums",
 *                                         "6",
 *                                         "512MB"),
 *                                     Map.entry("minimums", "3")
 *                                 )),
 *                                 Map.entry("storage", Map.of("volumeSize", "1Gi"))
 *                             ))
 *                         )),
 *                         Map.entry("engine", Map.of("extensions", Map.of("name", "citus"))),
 *                         Map.entry("scale", Map.of("shards", 3)),
 *                         Map.entry("scheduling", Map.of("default", Map.of("resources", Map.of("requests", Map.of("memory", "256Mi"))))),
 *                         Map.entry("service", Map.of("type", "NodePort")),
 *                         Map.entry("storage", Map.ofEntries(
 *                             Map.entry("data", Map.ofEntries(
 *                                 Map.entry("className", "local-storage"),
 *                                 Map.entry("size", "5Gi")
 *                             )),
 *                             Map.entry("logs", Map.ofEntries(
 *                                 Map.entry("className", "local-storage"),
 *                                 Map.entry("size", "5Gi")
 *                             ))
 *                         ))
 *                     )),
 *                     Map.entry("status", Map.ofEntries(
 *                         Map.entry("externalEndpoint", null),
 *                         Map.entry("readyPods", "4/4"),
 *                         Map.entry("state", "Ready")
 *                     ))
 *                 ))
 *                 .build())
 *             .resourceGroupName("testrg")
 *             .sku(PostgresInstanceSkuArgs.builder()
 *                 .dev(true)
 *                 .name("default")
 *                 .tier("Hyperscale")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurearcdata:PostgresInstance testpostgresInstance /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/postgresInstances/{postgresInstanceName}
 * ```
 * @property extendedLocation The extendedLocation of the resource.
 * @property location The geo-location where the resource lives
 * @property postgresInstanceName Name of Postgres Instance
 * @property properties null
 * @property resourceGroupName The name of the Azure resource group
 * @property sku Resource sku.
 * @property tags Resource tags.
 */
public data class PostgresInstanceArgs(
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val postgresInstanceName: Output<String>? = null,
    public val properties: Output<PostgresInstancePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<PostgresInstanceSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.PostgresInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.PostgresInstanceArgs =
        com.pulumi.azurenative.azurearcdata.PostgresInstanceArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .postgresInstanceName(postgresInstanceName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PostgresInstanceArgs].
 */
@PulumiTagMarker
public class PostgresInstanceArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var postgresInstanceName: Output<String>? = null

    private var properties: Output<PostgresInstancePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<PostgresInstanceSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("cyllinhtrnstcwfc")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("idwwkhmohynibwgw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of Postgres Instance
     */
    @JvmName("jxphwyoadxtgdioi")
    public suspend fun postgresInstanceName(`value`: Output<String>) {
        this.postgresInstanceName = value
    }

    /**
     * @param value null
     */
    @JvmName("ikmqrcpjfnvoscps")
    public suspend fun properties(`value`: Output<PostgresInstancePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("wmmctylhmnymambt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource sku.
     */
    @JvmName("ipccymakkqqmuuuh")
    public suspend fun sku(`value`: Output<PostgresInstanceSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rsdwrfpmbctumqnw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("yfyegynmvtfebfjl")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extendedLocation of the resource.
     */
    @JvmName("dilfnrqgeciygego")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("bxlmqyvycjkvtuda")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of Postgres Instance
     */
    @JvmName("turqlwaamxbhokva")
    public suspend fun postgresInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postgresInstanceName = mapped
    }

    /**
     * @param value null
     */
    @JvmName("itmxboarfmwtthqx")
    public suspend fun properties(`value`: PostgresInstancePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument null
     */
    @JvmName("hdkmgcwkyfuyqgqu")
    public suspend fun properties(argument: suspend PostgresInstancePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PostgresInstancePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("krrajekmibjortkc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource sku.
     */
    @JvmName("mnaapnnlfvqfkbim")
    public suspend fun sku(`value`: PostgresInstanceSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Resource sku.
     */
    @JvmName("fvkivvmarkrvekqp")
    public suspend fun sku(argument: suspend PostgresInstanceSkuArgsBuilder.() -> Unit) {
        val toBeMapped = PostgresInstanceSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hbrncmkapcculfnc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("omvdhthbryyueloy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PostgresInstanceArgs = PostgresInstanceArgs(
        extendedLocation = extendedLocation,
        location = location,
        postgresInstanceName = postgresInstanceName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
