@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * State of the database.
 */
public enum class DatabaseState(
    public val javaValue: com.pulumi.azurenative.azurearcdata.enums.DatabaseState,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.enums.DatabaseState> {
    Online(com.pulumi.azurenative.azurearcdata.enums.DatabaseState.Online),
    Restoring(com.pulumi.azurenative.azurearcdata.enums.DatabaseState.Restoring),
    Recovering(com.pulumi.azurenative.azurearcdata.enums.DatabaseState.Recovering),
    RecoveryPending(com.pulumi.azurenative.azurearcdata.enums.DatabaseState.RecoveryPending),
    Suspect(com.pulumi.azurenative.azurearcdata.enums.DatabaseState.Suspect),
    Emergency(com.pulumi.azurenative.azurearcdata.enums.DatabaseState.Emergency),
    Offline(com.pulumi.azurenative.azurearcdata.enums.DatabaseState.Offline),
    Copying(com.pulumi.azurenative.azurearcdata.enums.DatabaseState.Copying),
    OfflineSecondary(com.pulumi.azurenative.azurearcdata.enums.DatabaseState.OfflineSecondary),
    ;

    override fun toJava(): com.pulumi.azurenative.azurearcdata.enums.DatabaseState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.enums.DatabaseState): DatabaseState = DatabaseState.values().first { it.javaValue == javaType }
    }
}
