@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorStatusArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The status of the Kubernetes custom resource.
 * @property lastUpdateTime The time that the custom resource was last updated.
 * @property observedGeneration The version of the replicaSet associated with the AD connector custom resource.
 * @property state The state of the AD connector custom resource.
 */
public data class ActiveDirectoryConnectorStatusArgs(
    public val lastUpdateTime: Output<String>? = null,
    public val observedGeneration: Output<Double>? = null,
    public val state: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorStatusArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorStatusArgs =
        com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorStatusArgs.builder()
            .lastUpdateTime(lastUpdateTime?.applyValue({ args0 -> args0 }))
            .observedGeneration(observedGeneration?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ActiveDirectoryConnectorStatusArgs].
 */
@PulumiTagMarker
public class ActiveDirectoryConnectorStatusArgsBuilder internal constructor() {
    private var lastUpdateTime: Output<String>? = null

    private var observedGeneration: Output<Double>? = null

    private var state: Output<String>? = null

    /**
     * @param value The time that the custom resource was last updated.
     */
    @JvmName("pbplxhilotbuiykl")
    public suspend fun lastUpdateTime(`value`: Output<String>) {
        this.lastUpdateTime = value
    }

    /**
     * @param value The version of the replicaSet associated with the AD connector custom resource.
     */
    @JvmName("iiwfxmretsibnjso")
    public suspend fun observedGeneration(`value`: Output<Double>) {
        this.observedGeneration = value
    }

    /**
     * @param value The state of the AD connector custom resource.
     */
    @JvmName("kanmmqaforxifpph")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value The time that the custom resource was last updated.
     */
    @JvmName("foqhtboybkfjrcde")
    public suspend fun lastUpdateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastUpdateTime = mapped
    }

    /**
     * @param value The version of the replicaSet associated with the AD connector custom resource.
     */
    @JvmName("vprlpelpiwhvrhrq")
    public suspend fun observedGeneration(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.observedGeneration = mapped
    }

    /**
     * @param value The state of the AD connector custom resource.
     */
    @JvmName("pdukrtoxymtgeqid")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): ActiveDirectoryConnectorStatusArgs = ActiveDirectoryConnectorStatusArgs(
        lastUpdateTime = lastUpdateTime,
        observedGeneration = observedGeneration,
        state = state,
    )
}
