@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.AvailabilityGroupConfigureArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The specifications of the availability group replica configuration
 * @property backupPriority Represents the user-specified priority for performing backups on this replica relative to the other replicas in the same availability group.
 * @property endpointUrl Mirroring endpoint URL of availability group replica
 * @property readOnlyRoutingUrl Connectivity endpoint (URL) of the read only availability replica.
 * @property readWriteRoutingUrl Connectivity endpoint (URL) of the read write availability replica.
 * @property sessionTimeout The time-out period of availability group session replica, in seconds.
 */
public data class AvailabilityGroupConfigureArgs(
    public val backupPriority: Output<Int>? = null,
    public val endpointUrl: Output<String>? = null,
    public val readOnlyRoutingUrl: Output<String>? = null,
    public val readWriteRoutingUrl: Output<String>? = null,
    public val sessionTimeout: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.AvailabilityGroupConfigureArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.AvailabilityGroupConfigureArgs =
        com.pulumi.azurenative.azurearcdata.inputs.AvailabilityGroupConfigureArgs.builder()
            .backupPriority(backupPriority?.applyValue({ args0 -> args0 }))
            .endpointUrl(endpointUrl?.applyValue({ args0 -> args0 }))
            .readOnlyRoutingUrl(readOnlyRoutingUrl?.applyValue({ args0 -> args0 }))
            .readWriteRoutingUrl(readWriteRoutingUrl?.applyValue({ args0 -> args0 }))
            .sessionTimeout(sessionTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AvailabilityGroupConfigureArgs].
 */
@PulumiTagMarker
public class AvailabilityGroupConfigureArgsBuilder internal constructor() {
    private var backupPriority: Output<Int>? = null

    private var endpointUrl: Output<String>? = null

    private var readOnlyRoutingUrl: Output<String>? = null

    private var readWriteRoutingUrl: Output<String>? = null

    private var sessionTimeout: Output<Int>? = null

    /**
     * @param value Represents the user-specified priority for performing backups on this replica relative to the other replicas in the same availability group.
     */
    @JvmName("uswpmrkohndcuevc")
    public suspend fun backupPriority(`value`: Output<Int>) {
        this.backupPriority = value
    }

    /**
     * @param value Mirroring endpoint URL of availability group replica
     */
    @JvmName("aaefjfcssuibaqfc")
    public suspend fun endpointUrl(`value`: Output<String>) {
        this.endpointUrl = value
    }

    /**
     * @param value Connectivity endpoint (URL) of the read only availability replica.
     */
    @JvmName("lfdvnxoegknxuaje")
    public suspend fun readOnlyRoutingUrl(`value`: Output<String>) {
        this.readOnlyRoutingUrl = value
    }

    /**
     * @param value Connectivity endpoint (URL) of the read write availability replica.
     */
    @JvmName("sejwemcldsdvhtfy")
    public suspend fun readWriteRoutingUrl(`value`: Output<String>) {
        this.readWriteRoutingUrl = value
    }

    /**
     * @param value The time-out period of availability group session replica, in seconds.
     */
    @JvmName("obhoeaiodimxgbqt")
    public suspend fun sessionTimeout(`value`: Output<Int>) {
        this.sessionTimeout = value
    }

    /**
     * @param value Represents the user-specified priority for performing backups on this replica relative to the other replicas in the same availability group.
     */
    @JvmName("wbrdiiyqwnvuoqfq")
    public suspend fun backupPriority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupPriority = mapped
    }

    /**
     * @param value Mirroring endpoint URL of availability group replica
     */
    @JvmName("sbisfnoilipblsol")
    public suspend fun endpointUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointUrl = mapped
    }

    /**
     * @param value Connectivity endpoint (URL) of the read only availability replica.
     */
    @JvmName("mjyegggfsatodron")
    public suspend fun readOnlyRoutingUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnlyRoutingUrl = mapped
    }

    /**
     * @param value Connectivity endpoint (URL) of the read write availability replica.
     */
    @JvmName("avifayktdntjdnoh")
    public suspend fun readWriteRoutingUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readWriteRoutingUrl = mapped
    }

    /**
     * @param value The time-out period of availability group session replica, in seconds.
     */
    @JvmName("igioegodddekssqk")
    public suspend fun sessionTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionTimeout = mapped
    }

    internal fun build(): AvailabilityGroupConfigureArgs = AvailabilityGroupConfigureArgs(
        backupPriority = backupPriority,
        endpointUrl = endpointUrl,
        readOnlyRoutingUrl = readOnlyRoutingUrl,
        readWriteRoutingUrl = readWriteRoutingUrl,
        sessionTimeout = sessionTimeout,
    )
}
