@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.AvailabilityGroupInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The specifications of the availability group state
 * @property basicFeatures Specifies whether this is a basic availability group.
 * @property dbFailover Specifies whether the availability group supports failover for database health conditions.
 * @property dtcSupport Specifies whether DTC support has been enabled for this availability group.
 * @property failureConditionLevel User-defined failure condition level under which an automatic failover must be triggered.
 * @property healthCheckTimeout Wait time (in milliseconds) for the sp_server_diagnostics system stored procedure to return server-health information, before the server instance is assumed to be slow or not responding.
 * @property isContained SQL Server availability group contained system databases.
 * @property isDistributed Specifies whether this is a distributed availability group.
 * @property requiredSynchronizedSecondariesToCommit The number of secondary replicas that must be in a synchronized state for a commit to complete.
 */
public data class AvailabilityGroupInfoArgs(
    public val basicFeatures: Output<Boolean>? = null,
    public val dbFailover: Output<Boolean>? = null,
    public val dtcSupport: Output<Boolean>? = null,
    public val failureConditionLevel: Output<Int>? = null,
    public val healthCheckTimeout: Output<Int>? = null,
    public val isContained: Output<Boolean>? = null,
    public val isDistributed: Output<Boolean>? = null,
    public val requiredSynchronizedSecondariesToCommit: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.AvailabilityGroupInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.AvailabilityGroupInfoArgs =
        com.pulumi.azurenative.azurearcdata.inputs.AvailabilityGroupInfoArgs.builder()
            .basicFeatures(basicFeatures?.applyValue({ args0 -> args0 }))
            .dbFailover(dbFailover?.applyValue({ args0 -> args0 }))
            .dtcSupport(dtcSupport?.applyValue({ args0 -> args0 }))
            .failureConditionLevel(failureConditionLevel?.applyValue({ args0 -> args0 }))
            .healthCheckTimeout(healthCheckTimeout?.applyValue({ args0 -> args0 }))
            .isContained(isContained?.applyValue({ args0 -> args0 }))
            .isDistributed(isDistributed?.applyValue({ args0 -> args0 }))
            .requiredSynchronizedSecondariesToCommit(
                requiredSynchronizedSecondariesToCommit?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [AvailabilityGroupInfoArgs].
 */
@PulumiTagMarker
public class AvailabilityGroupInfoArgsBuilder internal constructor() {
    private var basicFeatures: Output<Boolean>? = null

    private var dbFailover: Output<Boolean>? = null

    private var dtcSupport: Output<Boolean>? = null

    private var failureConditionLevel: Output<Int>? = null

    private var healthCheckTimeout: Output<Int>? = null

    private var isContained: Output<Boolean>? = null

    private var isDistributed: Output<Boolean>? = null

    private var requiredSynchronizedSecondariesToCommit: Output<Int>? = null

    /**
     * @param value Specifies whether this is a basic availability group.
     */
    @JvmName("kmvfgkavisjaeeob")
    public suspend fun basicFeatures(`value`: Output<Boolean>) {
        this.basicFeatures = value
    }

    /**
     * @param value Specifies whether the availability group supports failover for database health conditions.
     */
    @JvmName("uaftbghyiciahtge")
    public suspend fun dbFailover(`value`: Output<Boolean>) {
        this.dbFailover = value
    }

    /**
     * @param value Specifies whether DTC support has been enabled for this availability group.
     */
    @JvmName("xqpgqpetsqxgxquf")
    public suspend fun dtcSupport(`value`: Output<Boolean>) {
        this.dtcSupport = value
    }

    /**
     * @param value User-defined failure condition level under which an automatic failover must be triggered.
     */
    @JvmName("chfedocdprwlqjfs")
    public suspend fun failureConditionLevel(`value`: Output<Int>) {
        this.failureConditionLevel = value
    }

    /**
     * @param value Wait time (in milliseconds) for the sp_server_diagnostics system stored procedure to return server-health information, before the server instance is assumed to be slow or not responding.
     */
    @JvmName("lnsuaruyawawexep")
    public suspend fun healthCheckTimeout(`value`: Output<Int>) {
        this.healthCheckTimeout = value
    }

    /**
     * @param value SQL Server availability group contained system databases.
     */
    @JvmName("lmetbfeaypmyyfbg")
    public suspend fun isContained(`value`: Output<Boolean>) {
        this.isContained = value
    }

    /**
     * @param value Specifies whether this is a distributed availability group.
     */
    @JvmName("qgoltlidopaioayp")
    public suspend fun isDistributed(`value`: Output<Boolean>) {
        this.isDistributed = value
    }

    /**
     * @param value The number of secondary replicas that must be in a synchronized state for a commit to complete.
     */
    @JvmName("jydexipxchpjjtqn")
    public suspend fun requiredSynchronizedSecondariesToCommit(`value`: Output<Int>) {
        this.requiredSynchronizedSecondariesToCommit = value
    }

    /**
     * @param value Specifies whether this is a basic availability group.
     */
    @JvmName("yawjqmwafthxkiyf")
    public suspend fun basicFeatures(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basicFeatures = mapped
    }

    /**
     * @param value Specifies whether the availability group supports failover for database health conditions.
     */
    @JvmName("euresfbkdybimgsj")
    public suspend fun dbFailover(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbFailover = mapped
    }

    /**
     * @param value Specifies whether DTC support has been enabled for this availability group.
     */
    @JvmName("mwhcqpdbcypxcywk")
    public suspend fun dtcSupport(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dtcSupport = mapped
    }

    /**
     * @param value User-defined failure condition level under which an automatic failover must be triggered.
     */
    @JvmName("knkwobwatkoxgfyp")
    public suspend fun failureConditionLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureConditionLevel = mapped
    }

    /**
     * @param value Wait time (in milliseconds) for the sp_server_diagnostics system stored procedure to return server-health information, before the server instance is assumed to be slow or not responding.
     */
    @JvmName("wqkarxeionkogknn")
    public suspend fun healthCheckTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckTimeout = mapped
    }

    /**
     * @param value SQL Server availability group contained system databases.
     */
    @JvmName("ynfltcosvqrmpdwk")
    public suspend fun isContained(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isContained = mapped
    }

    /**
     * @param value Specifies whether this is a distributed availability group.
     */
    @JvmName("gfpcnjmumlvvxblh")
    public suspend fun isDistributed(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDistributed = mapped
    }

    /**
     * @param value The number of secondary replicas that must be in a synchronized state for a commit to complete.
     */
    @JvmName("jkuxfpptfwhjtawe")
    public suspend fun requiredSynchronizedSecondariesToCommit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredSynchronizedSecondariesToCommit = mapped
    }

    internal fun build(): AvailabilityGroupInfoArgs = AvailabilityGroupInfoArgs(
        basicFeatures = basicFeatures,
        dbFailover = dbFailover,
        dtcSupport = dtcSupport,
        failureConditionLevel = failureConditionLevel,
        healthCheckTimeout = healthCheckTimeout,
        isContained = isContained,
        isDistributed = isDistributed,
        requiredSynchronizedSecondariesToCommit = requiredSynchronizedSecondariesToCommit,
    )
}
