@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.DataControllerPropertiesArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.enums.Infrastructure
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The data controller properties.
 * @property basicLoginInformation Deprecated. Azure Arc Data Services data controller no longer expose any endpoint. All traffic are exposed through Kubernetes native API.
 * @property clusterId If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
 * @property extensionId If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
 * @property infrastructure The infrastructure the data controller is running on.
 * @property k8sRaw The raw kubernetes information
 * @property lastUploadedDate Last uploaded date from Kubernetes cluster. Defaults to current date time
 * @property logAnalyticsWorkspaceConfig Log analytics workspace id and primary key
 * @property logsDashboardCredential Login credential for logs dashboard on the Kubernetes cluster.
 * @property metricsDashboardCredential Login credential for metrics dashboard on the Kubernetes cluster.
 * @property onPremiseProperty Properties from the Kubernetes data controller
 * @property uploadServicePrincipal Deprecated. Service principal is deprecated in favor of Arc Kubernetes service extension managed identity.
 * @property uploadWatermark Properties on upload watermark.  Mostly timestamp for each upload data type
 */
public data class DataControllerPropertiesArgs(
    public val basicLoginInformation: Output<BasicLoginInformationArgs>? = null,
    public val clusterId: Output<String>? = null,
    public val extensionId: Output<String>? = null,
    public val infrastructure: Output<Infrastructure>? = null,
    public val k8sRaw: Output<Any>? = null,
    public val lastUploadedDate: Output<String>? = null,
    public val logAnalyticsWorkspaceConfig: Output<LogAnalyticsWorkspaceConfigArgs>? = null,
    public val logsDashboardCredential: Output<BasicLoginInformationArgs>? = null,
    public val metricsDashboardCredential: Output<BasicLoginInformationArgs>? = null,
    public val onPremiseProperty: Output<OnPremisePropertyArgs>? = null,
    public val uploadServicePrincipal: Output<UploadServicePrincipalArgs>? = null,
    public val uploadWatermark: Output<UploadWatermarkArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.DataControllerPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.DataControllerPropertiesArgs =
        com.pulumi.azurenative.azurearcdata.inputs.DataControllerPropertiesArgs.builder()
            .basicLoginInformation(
                basicLoginInformation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .extensionId(extensionId?.applyValue({ args0 -> args0 }))
            .infrastructure(infrastructure?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .k8sRaw(k8sRaw?.applyValue({ args0 -> args0 }))
            .lastUploadedDate(lastUploadedDate?.applyValue({ args0 -> args0 }))
            .logAnalyticsWorkspaceConfig(
                logAnalyticsWorkspaceConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .logsDashboardCredential(
                logsDashboardCredential?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .metricsDashboardCredential(
                metricsDashboardCredential?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .onPremiseProperty(onPremiseProperty?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .uploadServicePrincipal(
                uploadServicePrincipal?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .uploadWatermark(
                uploadWatermark?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataControllerPropertiesArgs].
 */
@PulumiTagMarker
public class DataControllerPropertiesArgsBuilder internal constructor() {
    private var basicLoginInformation: Output<BasicLoginInformationArgs>? = null

    private var clusterId: Output<String>? = null

    private var extensionId: Output<String>? = null

    private var infrastructure: Output<Infrastructure>? = null

    private var k8sRaw: Output<Any>? = null

    private var lastUploadedDate: Output<String>? = null

    private var logAnalyticsWorkspaceConfig: Output<LogAnalyticsWorkspaceConfigArgs>? = null

    private var logsDashboardCredential: Output<BasicLoginInformationArgs>? = null

    private var metricsDashboardCredential: Output<BasicLoginInformationArgs>? = null

    private var onPremiseProperty: Output<OnPremisePropertyArgs>? = null

    private var uploadServicePrincipal: Output<UploadServicePrincipalArgs>? = null

    private var uploadWatermark: Output<UploadWatermarkArgs>? = null

    /**
     * @param value Deprecated. Azure Arc Data Services data controller no longer expose any endpoint. All traffic are exposed through Kubernetes native API.
     */
    @JvmName("gxlkgivtobpnlmjo")
    public suspend fun basicLoginInformation(`value`: Output<BasicLoginInformationArgs>) {
        this.basicLoginInformation = value
    }

    /**
     * @param value If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
     */
    @JvmName("vqebrwecqokbtywu")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
     */
    @JvmName("dxqghabtnquecijh")
    public suspend fun extensionId(`value`: Output<String>) {
        this.extensionId = value
    }

    /**
     * @param value The infrastructure the data controller is running on.
     */
    @JvmName("whamyhwkvpbqtfrn")
    public suspend fun infrastructure(`value`: Output<Infrastructure>) {
        this.infrastructure = value
    }

    /**
     * @param value The raw kubernetes information
     */
    @JvmName("bcahwngdcbbnoooj")
    public suspend fun k8sRaw(`value`: Output<Any>) {
        this.k8sRaw = value
    }

    /**
     * @param value Last uploaded date from Kubernetes cluster. Defaults to current date time
     */
    @JvmName("ehqqxbgvhebowvbc")
    public suspend fun lastUploadedDate(`value`: Output<String>) {
        this.lastUploadedDate = value
    }

    /**
     * @param value Log analytics workspace id and primary key
     */
    @JvmName("lhjlqqydfgjchnnb")
    public suspend fun logAnalyticsWorkspaceConfig(`value`: Output<LogAnalyticsWorkspaceConfigArgs>) {
        this.logAnalyticsWorkspaceConfig = value
    }

    /**
     * @param value Login credential for logs dashboard on the Kubernetes cluster.
     */
    @JvmName("idpwbfihtefsasak")
    public suspend fun logsDashboardCredential(`value`: Output<BasicLoginInformationArgs>) {
        this.logsDashboardCredential = value
    }

    /**
     * @param value Login credential for metrics dashboard on the Kubernetes cluster.
     */
    @JvmName("kbvrredjdjcpvone")
    public suspend fun metricsDashboardCredential(`value`: Output<BasicLoginInformationArgs>) {
        this.metricsDashboardCredential = value
    }

    /**
     * @param value Properties from the Kubernetes data controller
     */
    @JvmName("kayjwbgypgxcbaqw")
    public suspend fun onPremiseProperty(`value`: Output<OnPremisePropertyArgs>) {
        this.onPremiseProperty = value
    }

    /**
     * @param value Deprecated. Service principal is deprecated in favor of Arc Kubernetes service extension managed identity.
     */
    @JvmName("eepedkoleyaaofhj")
    public suspend fun uploadServicePrincipal(`value`: Output<UploadServicePrincipalArgs>) {
        this.uploadServicePrincipal = value
    }

    /**
     * @param value Properties on upload watermark.  Mostly timestamp for each upload data type
     */
    @JvmName("tauxtflirykendwa")
    public suspend fun uploadWatermark(`value`: Output<UploadWatermarkArgs>) {
        this.uploadWatermark = value
    }

    /**
     * @param value Deprecated. Azure Arc Data Services data controller no longer expose any endpoint. All traffic are exposed through Kubernetes native API.
     */
    @JvmName("cremmfrtetvyoebt")
    public suspend fun basicLoginInformation(`value`: BasicLoginInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basicLoginInformation = mapped
    }

    /**
     * @param argument Deprecated. Azure Arc Data Services data controller no longer expose any endpoint. All traffic are exposed through Kubernetes native API.
     */
    @JvmName("stqmxyhphsqxtfwf")
    public suspend fun basicLoginInformation(argument: suspend BasicLoginInformationArgsBuilder.() -> Unit) {
        val toBeMapped = BasicLoginInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.basicLoginInformation = mapped
    }

    /**
     * @param value If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
     */
    @JvmName("ftwxsvtstorctyis")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
     */
    @JvmName("fbtnmikjqacubxoy")
    public suspend fun extensionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionId = mapped
    }

    /**
     * @param value The infrastructure the data controller is running on.
     */
    @JvmName("mlrqrpipokisucjd")
    public suspend fun infrastructure(`value`: Infrastructure?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructure = mapped
    }

    /**
     * @param value The raw kubernetes information
     */
    @JvmName("khqhnkdxjdflxvtq")
    public suspend fun k8sRaw(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.k8sRaw = mapped
    }

    /**
     * @param value Last uploaded date from Kubernetes cluster. Defaults to current date time
     */
    @JvmName("luvkbjlkptwlnaee")
    public suspend fun lastUploadedDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastUploadedDate = mapped
    }

    /**
     * @param value Log analytics workspace id and primary key
     */
    @JvmName("dxmocvwytijmodva")
    public suspend fun logAnalyticsWorkspaceConfig(`value`: LogAnalyticsWorkspaceConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logAnalyticsWorkspaceConfig = mapped
    }

    /**
     * @param argument Log analytics workspace id and primary key
     */
    @JvmName("hpcagkrgidcybkwg")
    public suspend fun logAnalyticsWorkspaceConfig(argument: suspend LogAnalyticsWorkspaceConfigArgsBuilder.() -> Unit) {
        val toBeMapped = LogAnalyticsWorkspaceConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logAnalyticsWorkspaceConfig = mapped
    }

    /**
     * @param value Login credential for logs dashboard on the Kubernetes cluster.
     */
    @JvmName("cuiupyadjutpyvqh")
    public suspend fun logsDashboardCredential(`value`: BasicLoginInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logsDashboardCredential = mapped
    }

    /**
     * @param argument Login credential for logs dashboard on the Kubernetes cluster.
     */
    @JvmName("kjcoebybskijmcvm")
    public suspend fun logsDashboardCredential(argument: suspend BasicLoginInformationArgsBuilder.() -> Unit) {
        val toBeMapped = BasicLoginInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logsDashboardCredential = mapped
    }

    /**
     * @param value Login credential for metrics dashboard on the Kubernetes cluster.
     */
    @JvmName("kdphmboeeondrevk")
    public suspend fun metricsDashboardCredential(`value`: BasicLoginInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricsDashboardCredential = mapped
    }

    /**
     * @param argument Login credential for metrics dashboard on the Kubernetes cluster.
     */
    @JvmName("clkturevdishnlve")
    public suspend fun metricsDashboardCredential(argument: suspend BasicLoginInformationArgsBuilder.() -> Unit) {
        val toBeMapped = BasicLoginInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.metricsDashboardCredential = mapped
    }

    /**
     * @param value Properties from the Kubernetes data controller
     */
    @JvmName("ppyygimsrcccqxyr")
    public suspend fun onPremiseProperty(`value`: OnPremisePropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onPremiseProperty = mapped
    }

    /**
     * @param argument Properties from the Kubernetes data controller
     */
    @JvmName("hjbereakgbyuumaw")
    public suspend fun onPremiseProperty(argument: suspend OnPremisePropertyArgsBuilder.() -> Unit) {
        val toBeMapped = OnPremisePropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.onPremiseProperty = mapped
    }

    /**
     * @param value Deprecated. Service principal is deprecated in favor of Arc Kubernetes service extension managed identity.
     */
    @JvmName("vevhdnhyfrebstup")
    public suspend fun uploadServicePrincipal(`value`: UploadServicePrincipalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uploadServicePrincipal = mapped
    }

    /**
     * @param argument Deprecated. Service principal is deprecated in favor of Arc Kubernetes service extension managed identity.
     */
    @JvmName("bcwmxlrxuucllmin")
    public suspend fun uploadServicePrincipal(argument: suspend UploadServicePrincipalArgsBuilder.() -> Unit) {
        val toBeMapped = UploadServicePrincipalArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.uploadServicePrincipal = mapped
    }

    /**
     * @param value Properties on upload watermark.  Mostly timestamp for each upload data type
     */
    @JvmName("gmuxagiwsfgdrogh")
    public suspend fun uploadWatermark(`value`: UploadWatermarkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uploadWatermark = mapped
    }

    /**
     * @param argument Properties on upload watermark.  Mostly timestamp for each upload data type
     */
    @JvmName("lxfryqhoojrvdifh")
    public suspend fun uploadWatermark(argument: suspend UploadWatermarkArgsBuilder.() -> Unit) {
        val toBeMapped = UploadWatermarkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.uploadWatermark = mapped
    }

    internal fun build(): DataControllerPropertiesArgs = DataControllerPropertiesArgs(
        basicLoginInformation = basicLoginInformation,
        clusterId = clusterId,
        extensionId = extensionId,
        infrastructure = infrastructure,
        k8sRaw = k8sRaw,
        lastUploadedDate = lastUploadedDate,
        logAnalyticsWorkspaceConfig = logAnalyticsWorkspaceConfig,
        logsDashboardCredential = logsDashboardCredential,
        metricsDashboardCredential = metricsDashboardCredential,
        onPremiseProperty = onPremiseProperty,
        uploadServicePrincipal = uploadServicePrincipal,
        uploadWatermark = uploadWatermark,
    )
}
