@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.GetActiveDirectoryConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property activeDirectoryConnectorName The name of the Active Directory connector instance
 * @property dataControllerName The name of the data controller
 * @property resourceGroupName The name of the Azure resource group
 */
public data class GetActiveDirectoryConnectorPlainArgs(
    public val activeDirectoryConnectorName: String,
    public val dataControllerName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.GetActiveDirectoryConnectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.GetActiveDirectoryConnectorPlainArgs =
        com.pulumi.azurenative.azurearcdata.inputs.GetActiveDirectoryConnectorPlainArgs.builder()
            .activeDirectoryConnectorName(activeDirectoryConnectorName.let({ args0 -> args0 }))
            .dataControllerName(dataControllerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetActiveDirectoryConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetActiveDirectoryConnectorPlainArgsBuilder internal constructor() {
    private var activeDirectoryConnectorName: String? = null

    private var dataControllerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Active Directory connector instance
     */
    @JvmName("jlljynodiakytgav")
    public suspend fun activeDirectoryConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.activeDirectoryConnectorName = mapped
    }

    /**
     * @param value The name of the data controller
     */
    @JvmName("fahhhowbvudotwma")
    public suspend fun dataControllerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataControllerName = mapped
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("wsyptqfqcktowqnp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetActiveDirectoryConnectorPlainArgs = GetActiveDirectoryConnectorPlainArgs(
        activeDirectoryConnectorName = activeDirectoryConnectorName ?: throw
            PulumiNullFieldException("activeDirectoryConnectorName"),
        dataControllerName = dataControllerName ?: throw PulumiNullFieldException("dataControllerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
