@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.GetPostgresInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property postgresInstanceName Name of Postgres Instance
 * @property resourceGroupName The name of the Azure resource group
 */
public data class GetPostgresInstancePlainArgs(
    public val postgresInstanceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.GetPostgresInstancePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.GetPostgresInstancePlainArgs =
        com.pulumi.azurenative.azurearcdata.inputs.GetPostgresInstancePlainArgs.builder()
            .postgresInstanceName(postgresInstanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPostgresInstancePlainArgs].
 */
@PulumiTagMarker
public class GetPostgresInstancePlainArgsBuilder internal constructor() {
    private var postgresInstanceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of Postgres Instance
     */
    @JvmName("wyocnyerhyvobgys")
    public suspend fun postgresInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.postgresInstanceName = mapped
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("ksyugoyryscgtbim")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPostgresInstancePlainArgs = GetPostgresInstancePlainArgs(
        postgresInstanceName = postgresInstanceName ?: throw
            PulumiNullFieldException("postgresInstanceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
