@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.GetSqlServerAvailabilityGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property availabilityGroupName Name of SQL Availability Group
 * @property resourceGroupName The name of the Azure resource group
 * @property sqlServerInstanceName Name of SQL Server Instance
 */
public data class GetSqlServerAvailabilityGroupPlainArgs(
    public val availabilityGroupName: String,
    public val resourceGroupName: String,
    public val sqlServerInstanceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.GetSqlServerAvailabilityGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.GetSqlServerAvailabilityGroupPlainArgs =
        com.pulumi.azurenative.azurearcdata.inputs.GetSqlServerAvailabilityGroupPlainArgs.builder()
            .availabilityGroupName(availabilityGroupName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sqlServerInstanceName(sqlServerInstanceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlServerAvailabilityGroupPlainArgs].
 */
@PulumiTagMarker
public class GetSqlServerAvailabilityGroupPlainArgsBuilder internal constructor() {
    private var availabilityGroupName: String? = null

    private var resourceGroupName: String? = null

    private var sqlServerInstanceName: String? = null

    /**
     * @param value Name of SQL Availability Group
     */
    @JvmName("grujoqjwyeepfoem")
    public suspend fun availabilityGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.availabilityGroupName = mapped
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("bfetnfmbvexiujnq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of SQL Server Instance
     */
    @JvmName("gtnhyjskdprepxyg")
    public suspend fun sqlServerInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlServerInstanceName = mapped
    }

    internal fun build(): GetSqlServerAvailabilityGroupPlainArgs =
        GetSqlServerAvailabilityGroupPlainArgs(
            availabilityGroupName = availabilityGroupName ?: throw
                PulumiNullFieldException("availabilityGroupName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            sqlServerInstanceName = sqlServerInstanceName ?: throw
                PulumiNullFieldException("sqlServerInstanceName"),
        )
}
