@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.K8sSchedulingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The kubernetes scheduling information.
 * @property default The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service
 */
public data class K8sSchedulingArgs(
    public val default: Output<K8sSchedulingOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.K8sSchedulingArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.K8sSchedulingArgs =
        com.pulumi.azurenative.azurearcdata.inputs.K8sSchedulingArgs.builder()
            .default_(default?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [K8sSchedulingArgs].
 */
@PulumiTagMarker
public class K8sSchedulingArgsBuilder internal constructor() {
    private var default: Output<K8sSchedulingOptionsArgs>? = null

    /**
     * @param value The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service
     */
    @JvmName("hhdasdodtuebixjx")
    public suspend fun default(`value`: Output<K8sSchedulingOptionsArgs>) {
        this.default = value
    }

    /**
     * @param value The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service
     */
    @JvmName("aeoukcfyahnqnkxi")
    public suspend fun default(`value`: K8sSchedulingOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.default = mapped
    }

    /**
     * @param argument The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service
     */
    @JvmName("ukcvhrxiycmrcrdr")
    public suspend fun default(argument: suspend K8sSchedulingOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = K8sSchedulingOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.default = mapped
    }

    internal fun build(): K8sSchedulingArgs = K8sSchedulingArgs(
        default = default,
    )
}
