@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.K8sSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The kubernetes settings information.
 * @property network The kubernetes network settings information.
 */
public data class K8sSettingsArgs(
    public val network: Output<K8sNetworkSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.K8sSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.K8sSettingsArgs =
        com.pulumi.azurenative.azurearcdata.inputs.K8sSettingsArgs.builder()
            .network(network?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [K8sSettingsArgs].
 */
@PulumiTagMarker
public class K8sSettingsArgsBuilder internal constructor() {
    private var network: Output<K8sNetworkSettingsArgs>? = null

    /**
     * @param value The kubernetes network settings information.
     */
    @JvmName("bqdbxuitkmblfbhp")
    public suspend fun network(`value`: Output<K8sNetworkSettingsArgs>) {
        this.network = value
    }

    /**
     * @param value The kubernetes network settings information.
     */
    @JvmName("xeunnpvralphsifb")
    public suspend fun network(`value`: K8sNetworkSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.network = mapped
    }

    /**
     * @param argument The kubernetes network settings information.
     */
    @JvmName("knprxftdopvrojut")
    public suspend fun network(argument: suspend K8sNetworkSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = K8sNetworkSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.network = mapped
    }

    internal fun build(): K8sSettingsArgs = K8sSettingsArgs(
        network = network,
    )
}
