@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.LogAnalyticsWorkspaceConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Log analytics workspace id and primary key
 * @property primaryKey Primary key of the workspace
 * @property workspaceId Azure Log Analytics workspace ID
 */
public data class LogAnalyticsWorkspaceConfigArgs(
    public val primaryKey: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.LogAnalyticsWorkspaceConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.LogAnalyticsWorkspaceConfigArgs = com.pulumi.azurenative.azurearcdata.inputs.LogAnalyticsWorkspaceConfigArgs.builder()
        .primaryKey(primaryKey?.applyValue({ args0 -> args0 }))
        .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogAnalyticsWorkspaceConfigArgs].
 */
@PulumiTagMarker
public class LogAnalyticsWorkspaceConfigArgsBuilder internal constructor() {
    private var primaryKey: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value Primary key of the workspace
     */
    @JvmName("vtyepgveyoyyapsw")
    public suspend fun primaryKey(`value`: Output<String>) {
        this.primaryKey = value
    }

    /**
     * @param value Azure Log Analytics workspace ID
     */
    @JvmName("lbrmsmwopgrnwfnj")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value Primary key of the workspace
     */
    @JvmName("iimpiyeurhcfmbei")
    public suspend fun primaryKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryKey = mapped
    }

    /**
     * @param value Azure Log Analytics workspace ID
     */
    @JvmName("ubdxppnpxxphacao")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): LogAnalyticsWorkspaceConfigArgs = LogAnalyticsWorkspaceConfigArgs(
        primaryKey = primaryKey,
        workspaceId = workspaceId,
    )
}
