@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of Arc Sql availability group database replica resource
 * @property databaseName the database name.
 */
public data class SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs(
    public val databaseName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs =
        com.pulumi.azurenative.azurearcdata.inputs.SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs].
 */
@PulumiTagMarker
public class SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    /**
     * @param value the database name.
     */
    @JvmName("wnhcfajuhkmgmpyf")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value the database name.
     */
    @JvmName("avsinghkmghocmrk")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    internal fun build(): SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs =
        SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs(
            databaseName = databaseName,
        )
}
